/* $Id: atomic.h,v 1.5 1998/09/03 16:40:09 bjornw Exp $ */

#ifndef __ARCH_ETRAX_ATOMIC__
#define __ARCH_ETRAX_ATOMIC__

#include <asm/system.h>

/*
 * Atomic operations that C can't guarantee us.  Useful for
 * resource counting etc..
 */

#ifdef __SMP__
#define LOCK "lock ; "
#else
#define LOCK ""
#endif

/*
 * Make sure gcc doesn't try to be clever and move things around
 * on us. We need to use _exactly_ the address the user gave us,
 * not some alias that contains the same information.
 */
#define __atomic_fool_gcc(x) (*(struct { int a[100]; } *)x)

typedef volatile int atomic_t;

/* These should be written in asm but we do it in C for now. */

static __inline__ void atomic_add(atomic_t i, atomic_t *v)
{
  unsigned long flags;
  save_flags(flags);
  cli();
  *v += i;
  restore_flags(flags);
}

static __inline__ void atomic_sub(atomic_t i, atomic_t *v)
{
  unsigned long flags;
  save_flags(flags);
  cli();
  *v -= i;
  restore_flags(flags);
}

static __inline__ void atomic_inc(atomic_t *v)
{
  unsigned long flags;
  save_flags(flags);
  cli();
  (*v)++;
  restore_flags(flags);
}

static __inline__ void atomic_dec(atomic_t *v)
{
  unsigned long flags;
  save_flags(flags);
  cli();
  (*v)--;
  restore_flags(flags);
}

static __inline__ int atomic_dec_and_test(atomic_t *v)
{
  int retval;
  unsigned long flags;
  save_flags(flags);
  cli();
  retval = --(*v) == 0;
  restore_flags(flags);
  return retval;
}

#endif
