#!/bin/sh
#!##############################################################
#!
#! Bin-cris: get the binary stuff from a CRIS linked file
#!
#! Check some historic parameters, weed out outfile and infile, and get
#! the binary file from the infile, write it to outfile.
#!  The reason for this script is mostly historical.
#! It is very simple to implement in any language
#!
#! Sep 08 1997  H-P Nilsson   Initial.  Not in SCCS yet...
#!
#!##############################################################
# %Z% %M% %I% %G%
progname=$0
infile=
outfile=
width=
block=
tmpfile=$outfile.tmp.$$

options()
{
  if test "X$1" != "X"; then
    echo "$progname: $*.  Usage:";
  fi;
  cat <<EOF
$progname [-w width] [-b block] infile [-o] outfile:
Make a binary (rom-able) image from a final linked file in a.out-cris format,
with a little help from objcopy-cris.  Options:
  -w width      Number of byte-wide proms: 1=8 bits, 2=2*8 bits
  -b block      Which block to create; valid with "-w 2".  0=low, 1=high
  -o outfile    Optional; To just stat outfile without "-o" works as well.
EOF
}

if test $# -eq 0 ; then
 options "No parameters given.  Usage:";
 exit 1;
fi;

while test $# -ne 0 ; do
 case $1 in
 -w | -b | -o)
  if test $# -eq 1; then
    options "No parameter given to \"$1\"";
    exit 1;
  fi;;
 esac;
   
 case $1 in
 -w)
   width=$2; shift;;
 -w*)
   width=`echo $1 | cut -c3-`;;
 -b)
   block=$2; shift;;
 -b*)
   block=`echo $1 | cut -c3-`;;
 -o)
   outfile=$2; shift;;
 -o*)
   outfile=`echo $1 | cut -c3-`;;
 -h | --help | -? | -help)
   options; exit 0;;
 -*)
   echo "Unknown parameter \"$1\"";
   options; exit 1;;
 *)
   if test "X$infile" != "X" ; then
     outfile=$1;
   else
     infile=$1;
   fi;;
 esac;

 shift;  
done;

if test "X$width" != "X" && test "X$width" != "X1" && test "X$width" != "X2"; then
 options "Illegal width value: $width";
 exit 1;
fi

if test "X$block" != "X" && test "X$block" != "X0" && test "X$block" != "X1"; then
 options "Illegal block value: $block";
 exit 1;
fi

if test "X$infile" = "X"; then
 options "No input file given";
 exit 1;
fi

if test "X$outfile" = "X"; then
 options "No output file given";
 exit 1;
fi

#cat <<EOF
#-w : $width
#-b : $block
#-o : $outfile
#infile : $infile
#EOF

#
# objcopy has a problem with more than one segment and using "-i".
# Therefore we first output the dump from the .text segment, and then output
# the dump from the .data segment to a temporary file, which is then
# concatenated to the "real" output-file, and the temporary is removed.
#
opts=
if test "X$width" != "X" && test "X$width" = "X2"; then
  opts="-i 2 -b $block -R .data";
fi;

if objcopy-cris -O binary $opts $infile $outfile; then
 true;
else
 exit $?;
fi;

if test "X$opts" != "X"; then
 if objcopy-cris -O binary -R .text -i 2 -b $block $infile $tmpfile && cat $tmpfile >>$outfile && rm -f $tmpfile; then
  true;
 else
  rm -f $tmpfile 2>/dev/null;
  exit $?;
 fi;
fi;

exit 0;
