#include <math.h>
#include "xstdio.h"

/* _Ldunscale function -- IEEE 754 version */
short _Ldunscale(short *pex, long double *px)
	{	/* separate *px to |frac| < 1/2 and 2^*pex */
	  int i;
	  double d,dd;
	  d = dd = *px;
	  if (__isinf(d))
	    return INF;
	  if (__isnan(d))
	    return NAN;
	  if (d == 0.0)
	    return 0;
	  d = frexp(d,&i);
/*	  if (fabs(d) > 0.5)
	    d /=2.0,i ++;
*/	  *pex = i;
	  *px = d;
	  return FINITE;
	}
