/* _Getmem function -- UNIX version */
#include "xalloc.h"
#include "simcodes.h"

		/* UNIX system call */
static void *_Sbrk(int d)
{
  static struct partyp par;
  void *p;
  par.i = d;
  __asm__("bmod [%1],%0" : "=r" (p) : "r" (S_sbrk) , "0" (&par));
  if (p == (void *) -1) 
    errno = ENOMEM;
  return p;
}

void *_Getmem(size_t size)
	{	/* allocate raw storage */
	void *p;
	int isize = size;

	return (isize <= 0 || (p = _Sbrk(isize)) == (void *)-1
		? NULL : p);
	}
