/* See how to declare a "constant" function (given same parameters
   will always return same value) */
/* History:
 *
 * Date:    Name:     Comment:
 * 940502   HP        Commented, ">=" bug fixed in Udiv and Umod.
 */
#if (__GNUC__ >= 2) && (__GNUC_MINOR__ >= 6)
#define CONSTF
#define CONSTA __attribute((const))
#else
#define CONSTF const
#define CONSTA
#endif

extern CONSTF long __Mul(unsigned long a, unsigned long b) CONSTA;

CONSTF long __Mul(unsigned long a, unsigned long b)
{
  /* This must be compiled with the -mul flag. */
#if 0
  unsigned long min;

  /* Get minimum via the bound insn. */
  min = a < b ? a : b;

  /* Can we omit some widening? */
  if (min > 65535)
    /* No. Perform full widening. */
#endif
    return a*b;
#if 0
  else {
    /* Check if both are within 16 bits. */
    unsigned long max;

    /* Get maximum, by knowing the minimum.
       This will partition a and b into max and min.
        This is not currently something Gcc understands,
       so do this trick via asm. */
    __asm__ ("xor %1,%0\n\txor %2,%0" : "=r" (max) :  "r" (b), "r" (a), "0" (min));
    
    if (max > 65535)
      /* Make Gcc understand that only the low part of "min" will be used. */
      return max*((unsigned short)min);
    else
      /* Only low parts */
      return ((unsigned short max)*((unsigned short) min);
  }    
#endif
}

struct quot_rem {
  long quot;
  long rem;
};

static CONSTF __inline__ struct quot_rem
do_31div(unsigned long a, unsigned long b) CONSTA;

static CONSTF __inline__ struct quot_rem
do_31div(unsigned long a, unsigned long b)
{
  /* Adjust operands and result if a is 31 bits. */

  long extra = 0;
  int quot_digits = 0;

  if (b == 0) {
    struct quot_rem ret;
    ret.quot = 0xffffffff;
    ret.rem = 0xffffffff;
    return ret;
  }

  if (a < b)
    return (struct quot_rem) { 0, a };

#ifdef LZ
  quot_digits = LZ(a) - LZ(b) + 1;
  b <<= quot_digits;
#else
  while (b <= a)
  { b <<= 1; quot_digits++;}
#endif
  
  /* Is a 31 bits? (Highest bit checked by caller) */
  if (a & 0x40000000) {

    /* Then make b:s highest bit max 0x40000000
       (because it must have been 0x80000000 to be 1 bit higher
       than a). */
    b >>= 1;

    /* Adjust a to be maximum 0x3fffffff, i.e. two upper bits zero. */
    if (a >= b) /* Note: change from '>' to '>=' HP931007 */
      {
	a -= b;
	extra = 1 << (quot_digits - 1);
      }
    else {
      a -= b >> 1;

      /* Remember that we adjusted a by subtracting b*2^something. */
      extra = 1 << quot_digits;
    }

    /* Number of quotient digits will be one less, because
       we just adjusted b. */
    quot_digits--;
    
  }
    
  /* Now do the division part. */

  /* Subtract b and add ones to the right when a >= b
     i.e. a -  (b-1) == (a - b) + 1 */
  b--;				

#define DS __asm__ ("dstep %2,%0" : "=r" (a) : "0" (a), "r" (b))

  switch(quot_digits) {
  case 32: DS; case 31: DS; case 30: DS; case 29: DS;
  case 28: DS; case 27: DS; case 26: DS; case 25: DS;
  case 24: DS; case 23: DS; case 22: DS; case 21: DS;
  case 20: DS; case 19: DS; case 18: DS; case 17: DS;
  case 16: DS; case 15: DS; case 14: DS; case 13: DS;
  case 12: DS; case 11: DS; case 10: DS; case 9: DS;
  case 8: DS; case 7: DS; case 6: DS; case 5: DS;
  case 4: DS; case 3: DS; case 2: DS; case 1: DS;
  case 0:;
  }

  {
    struct quot_rem ret;
    ret.quot = (a & ((1 << quot_digits) - 1)) + extra;
    ret.rem = a >> quot_digits;
    return ret;
  }
}

extern unsigned CONSTF long __inline__
__Udiv(unsigned long a, unsigned long b) CONSTA;

unsigned CONSTF long __inline__
__Udiv(unsigned long a, unsigned long b)
{
  long extra = 0;

  /* Adjust operands and result if a and/or b is 32 bits */
  /* b & 0x80000000 */
  if ((long) b < 0)
    return a >= b;

  /* a & 0x80000000 */
  if ((long) a < 0) {
    int tmp = 0;

    if (b == 0)
      return 0xffffffff;
#ifdef LZ
    tmp = LZ(b);
#else
    
    for (tmp = 31; (((long) b & (1 << tmp)) == 0); tmp--)
      ;
    tmp = 31-tmp;
#endif

    if ((b << tmp) > a) {
      extra = 1 << (tmp-1);
      a -= b << (tmp - 1);
    } else {
      extra = 1 << tmp;
      a -= b << tmp;
    }
  }      

  return do_31div(a,b).quot+extra;
}

extern CONSTF long
__Div(long a, long b) CONSTA;

CONSTF long
__Div(long a, long b)
{
  long sign;
  long result;
  
  /* NOT do_31div since abs(-2147483648) == 2147483648
      <=> abs(-0x80000000) == 0x80000000
      which are 32 bits. */

  sign = a ^ b;
  result = __Udiv(abs(a),abs(b));
  
  return  (sign  < 0) ? -result : result;
}
  
extern CONSTF __inline__ unsigned long
__Umod(unsigned long a, unsigned long b) CONSTA;

CONSTF __inline__ unsigned long
__Umod(unsigned long a, unsigned long b)
{

  /* Adjust operands and result if a and/or b is 32 bits */
  if ((long) b < 0)
    return a >= b ? a - b : a;

  if ((long) a < 0) {
    int tmp = 0;

    if (b == 0)
      return a;
#ifdef LZ
    tmp = LZ(b);
#else
    for (tmp = 31; (((long) b & (1 << tmp)) == 0); tmp--)
      ;
    tmp = 31-tmp;
#endif

    if ((b << tmp) > a) {
      a -= b << (tmp - 1);
    } else {
      a -= b << tmp;
    }
  }      

  return do_31div(a,b).rem;
}

extern CONSTF long
__Mod(long a, long b) CONSTA;

CONSTF long
__Mod(long a, long b)
{
  long  result;

  result = __Umod(abs(a), abs(b));

  return (a < 0) ? -result : result;
}
