/* strtol function */
#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <stdlib.h>
extern unsigned long _Stoul();

long (strtol)(const char *s, char **endptr, int base)
	{	/* convert string to long, with checking */
	const char *sc;
	char c;
	unsigned long x;

	for (sc = s; isspace(*sc); ++sc)
		;

	c = *sc;
	x = _Stoul(c == '-' ? sc+1 : sc, endptr, base);
	if (endptr && (*endptr == (c == '-' ? sc+1 : sc)))
	  *endptr = (char *) s;
	if (c == '-' && x > LONG_MAX)
		{	/* negative number overflowed */
		errno = ERANGE;
		return (LONG_MIN);
		}
	else if (c != '-' && LONG_MAX < x)
		{	/* positive number overflowed */
		errno = ERANGE;
		return (LONG_MAX);
		}
	else
		return (c == '-' ? -(long)x : (long)x);
	}
