/*      stdlib.h

        Definitions for common types, variables, and functions.

        This instance for cris.
*/

#if     !defined(__STDLIB)
#define __STDLIB

#ifndef _STDDDEF_H_
#include <stddef.h>
#endif

#ifndef EDOM
#include <errno.h>
#endif

double   atof   (const char *s);
int      atoi   (const char *s);
long     atol   (const char *s);
double   strtod (const char *s, char **endptr);
long     strtol (const char *s, char **endptr, int radix);
unsigned long  strtoul (const char *s, char **endptr, int radix);
int      rand   (void);
void     srand  (unsigned seed);
void   * calloc (size_t nitems, size_t size);
void   * malloc (size_t size);
void   * realloc(void *block, size_t size);
void     free   (void *block);
void     abort  (void);
void     exit   (int status);
typedef void  (* atexit_t)(void);
int      atexit (atexit_t func);
int      system (const char *command);
char   * getenv (const char *name);
void   * bsearch(const void *key, const void *base, 
                 size_t nelem, size_t width,
                 int  (*fcmp)(const void *, const void *));

void     qsort  (void *base, size_t nelem, size_t width,
                 int  (*fcmp)(const void *, const void *));

#define EXIT_SUCCESS 0
#define EXIT_FAILURE (-1)

#define abs(x) __builtin_abs(x)

/* long abs(long) -- Makes an inline instruction. */
#define labs(x) __builtin_labs(x)

#ifndef _LDIV_T
#define _LDIV_T
typedef struct {
        long    quot;
        long    rem;
} ldiv_t;
#endif
#ifndef _DIV_T
#define _DIV_T
typedef struct {
        int     quot;
        int     rem;
} div_t;
#endif
extern div_t div (int numer, int denom);
extern __inline__ div_t    div    (int numer, int denom)
{ div_t res;
  if (denom == 0) errno = EDOM;
  res.quot = numer / denom; res.rem = numer % denom;
  return res;
}

extern ldiv_t ldiv (long numer, long denom);
extern __inline__ ldiv_t    ldiv    (long numer, long denom)
{ ldiv_t res;
  if (denom == 0) errno = EDOM;
  res.quot = numer / denom; res.rem = numer % denom;
  return res;
}

#endif
