/* bsearch function */
#include <stdlib.h>
#include <stddef.h>
typedef int (*_Cmpfun)(const void *,const void *);

void *(bsearch)(const void *key, const void *base,
	size_t nelem, size_t size, int (*fcmp)(const void *, const void *))
	{	/* search sorted table by binary chop */
	const char *p = base;
	size_t n;

	for (p = base, n = nelem; 0 < n; )
		{	/* check midpoint of whatever is left */
		const size_t pivot = n >> 1;
		const char *const q = p + size * pivot;
		const int val = (*fcmp)(key, q);

		if (val < 0)
			n = pivot;	/* search below pivot */
		else if (val == 0)
			return ((void *)q);	/* found */
		else
			{	/* search above pivot */
			p = q + size;
			n -= pivot + 1;
			}
		}
	return (NULL);	/* no match */
	}
