#include <stdio.h>
#include "simcodes.h"
#include <errno.h>
static char tmps[TMP_MAX][L_tmpnam] = {""};
static int tmpno = 0;

char *tmpnam(char *ss)
{
  int out;

  static struct partyp par = {0};

  /* Only 32 temporary names / invocation allowed. */
  if (*tmps[31]) {
    errno = errno ? errno :  ENFILE;
    return NULL;
  }

  if (ss == NULL)
    ss = tmps[tmpno++];

  par.s1 = ss;

  __asm__ ("bmod [%1],%0" : "=r" (out) : "r" (S_tmpnam) , "0" (&par));

  if (out) { errno = out; return NULL;}

  return ss;
}
