/* stdio.h for cris.
    If you make a "real" operating system (not using the simulator),
   note that you may have other definitions of the type "FILE" etc. */
#ifndef _STDIO
#define _STDIO
#ifndef _STDDEF_H_C
#include <stddef.h>
#endif


/* We must use va_list, so include varargs if not done. But we dont 
   know if user wants to include stdarg or varargs, so undef key
   macros and the varying one. All other macros are free to redefine,
   as long as the "re"-definition is the same. */
#ifndef _VARARGS_H
#include <stdarg.h>
#undef _VARARGS_H
#undef _STDARG_H
#undef _sys_varargs_h
#undef va_start
#endif
		/* macros */
#define FOPEN_MAX 32
#define FILENAME_MAX 1024
/* Standard, but vaguely mentioned. */
#define BUFSIZ 1024

#define stdin		(&_Files[0])
#define stdout		(&_Files[1])
#define stderr		(&_Files[2])

#undef EOF
#define EOF (-1)

#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2

#define _IOFBF	0
#define	_IONBF	04
#define	_IOLBF	0200
		/* type definitions */
typedef void *FILE;

#define P_tmpdir	"/usr/tmp/"
#define L_tmpnam	25		/* (sizeof(P_tmpdir) + 15) */
#define TMP_MAX 32

extern FILE _Files[FOPEN_MAX];

		/* declarations */
extern FILE *fopen(const char *, const char *);
extern FILE *freopen(const char *, const char *, FILE *);
extern int fflush(FILE *);
extern int fclose(FILE *);
extern int remove(const char *);
extern int rename(const char *, const char *);
extern FILE *tmpfile(void);
extern char *tmpnam(char *s);
extern int setvbuf(FILE *, char *, int, size_t);
extern void setbuf(FILE *, char *);
extern int fprintf(FILE *, const char *, ...);
extern int printf(const char *, ...);
extern int sprintf(char *, const char *, ...);
extern int vprintf(const char *, va_list);
extern int vfprintf(FILE *, const char *, va_list);
extern int vsprintf(char *, const char *, va_list);
extern int fscanf(FILE *, const char *, ...);
extern int scanf(const char *, ...);
extern int sscanf(const char *, const char *, ...);
extern int fgetc(FILE *);
extern char *fgets(char *, int, FILE *);
extern int fputc(int, FILE *);

#define getc(x) fgetc(x)
#define getchar() getc(stdin)
 
extern char *gets(char *);

#define putc(c,s) fputc(c,s)
#define putchar(c) putc(c,stdout)

extern void clearerr(FILE *);
extern int feof(FILE *);
extern int ferror(FILE *);
extern int fgetpos(FILE *, fpos_t *);
extern int fputs(const char *, FILE *);
extern size_t fread(void *, size_t, size_t, FILE *);
extern int fseek(FILE *, long, int);
extern int fsetpos(FILE *, const fpos_t *);
extern long ftell(FILE *);
extern size_t fwrite(const void *, size_t, size_t, FILE *);
extern void perror(const char *);
extern int puts(const char *);
extern void rewind(FILE *);
extern int ungetc(int, FILE *);
extern long _Fgpos(FILE *, fpos_t *);
extern int _Fspos(FILE *, const fpos_t *, long, int);
#endif
