/* RSIM/XSIM Simulator interface codes */
#ifndef _Rsim_Xsim_included
#define S_freopen 1
#define S_fclose 2
#define S_fflush 3
#define S_fputc 4
#define S_fgetc 5
#define S_system 6
#define S_remove 7
#define S_rename 8
#define S_tmpfile 9
#define S_tmpnam 10
#define S_fread 11
#define S_fwrite 12
#define S_fseek 13
#define S_exit 14
#define S_sbrk 15
#define S_ftell 16
#define S_clearerr 17
#define S_feof 18
#define S_ferror 19
#define S_strerror 20
#define S_getenv 21
#define S_time 22
#define S_debug 23
#define S_fsetpos 24


/* From here on not using struct */
#define S_idle 25
#define S_cpuid 26
#define S_cycles 27
#define S_simcycles 28
#define S_trace_on 255
#define S_trace_off 254

/* Now using struct again */
#define S_stat 29

struct partyp {
  int i,i1;
  char *s1,*s2;
  void *voidp;
  void *p1,*p2;
};

#define CRIS_CYCLES() __extension__ \
 ({ unsigned long c; asm ("bmod [%1],%0" : "=r" (c) : "r" (S_cycles)); c;})

#define CPU_NUMBER()  __extension__ \
 ({ unsigned long c; asm ("bmod [%1],%0" : "=r" (c) : "r" (S_cpuid)); c;})

#define WAIT_FOR_INTERRUPT() do { asm volatile ("bmod [%0],%0" :: "r" (S_idle)); } while (0)

#define TRACE_ON() __extension__ \
 ({ int _Foofoo; __asm__ volatile ("bmod [%0],%0" : "=r" (_Foofoo) : "0" \
			       (S_trace_on)); _Foofoo; })

#define TRACE_OFF() do { __asm__ volatile ("bmod [%0],%0" :: "r" (S_trace_off)); } while (0)

#define SIM_END() do { __asm__ volatile ("bmod [%0],%0" :: "r" (S_simcycles)); } while (0)
#endif /* _Rsim_Xsim_included */
