/* ============================================================================
*! FILE NAME  : setjmp.h
*! DESCRIPTION:
*! The function definitions of setjmp and longjmp for CRIS
*! ============================================================================
*/

#include <setjmp.h>

/* jmp_buf is a vector for PC,R14(sp)..R0,SRP,CCR */
/*
   Note that we save and restore CCR to be able to
   correctly handle DI/EI.  Note also that the "move x,ccr" does NOT affect
   the DMA enable bits (E and D).

   jmp_buf[0] - PC
   jmp_buf[1] - SP (R14)
   jmp_buf[2] - R13
   jmp_buf[3] - R12
   jmp_buf[4] - R11
   jmp_buf[5] - R10
   jmp_buf[6] - R9
   jmp_buf[7] - R8
   jmp_buf[8] - R7
   jmp_buf[9] - R6
   jmp_buf[10] - R5
   jmp_buf[11] - R4
   jmp_buf[12] - R3
   jmp_buf[13] - R2
   jmp_buf[14] - R1
   jmp_buf[15] - R0
   jmp_buf[16] - SRP
   jmp_buf[17] - CCR
   */

#if 0
typedef unsigned long int jmp_buf[18];
#endif

/* You better make sure this doesn't change stack pointer before
   returning, if you [cd]are to change it.   */
int
setjmp(jmp_buf buf)
{
  int ret;
  __asm__ __volatile__
    ("moveq 1,r9\n\t"
     "movem sp,[%1+1*4]\n\t"
     "move.d LL%=,r9\n\t"
     "move.d r9,[%1]\n\t"
     "move srp,[%1+16*4]\n\t"
     "move ccr,[%1+17*4]\n\t"
     "clear.d r9\n"
     "LL%=:\n\t"
     "move.d r9,%0"
     : "=&r" (ret)		/* output */
     : "r" (buf) :		/* input */
     "r9" );			/* slask */
  return ret;
}

void
longjmp(jmp_buf buf, int val) {
  __asm__ __volatile__
    ("move [%0+17*4],ccr\n\t"
     "move [%0+16*4],srp\n\t"
     "test.d %1\n\t"
     "beq 0f\n\t"
     "nop\n\t"
     "move.d %1,[%0+6*4]\n"	/* offset for r9 */
     "0:\n\t"
     "movem [%0],pc"
     : /* no outputs */
     : "r" (buf), "r" (val)); /* input */
}
/* End of setjmp.c */
