/* ANSI: math.h */
/* This instance for cris (IEEE 754 32bit float==double) */
#ifndef	_MATH_H
#define	_MATH_H

/* To get domain and overflow/underflow error numbers */
#include <errno.h>

/* Get HUGE_VAL (returned on overflow) from <float.h>.  */
#include <float.h>

/* See how to declare a "constant" function (given same parameters
   will always return same value) */
#ifndef	__CONSTVALUE
# ifdef __GNUC__
#  if (__GNUC__ >= 2) && (__GNUC_MINOR__ >= 6)
#   define __CONSTVALUE
#   define __CONSTATTR __attribute((__const))
#  else
#   define __CONSTVALUE __const
#   define __CONSTATTR
#  endif
# else
#  define __CONSTVALUE
#  define __CONSTATTR
# endif
#endif


extern __CONSTVALUE double acos(double __x) __CONSTATTR;
extern __CONSTVALUE double asin(double __x) __CONSTATTR;
extern __CONSTVALUE double atan(double __x) __CONSTATTR;
extern __CONSTVALUE double atan2(double __y, double __x) __CONSTATTR;
extern __CONSTVALUE double cos(double __x) __CONSTATTR;
extern __CONSTVALUE double sin(double __x) __CONSTATTR;
extern __CONSTVALUE double tan(double __x) __CONSTATTR;
extern __CONSTVALUE double cosh(double __x) __CONSTATTR;
extern __CONSTVALUE double sinh(double __x) __CONSTATTR;
extern __CONSTVALUE double tanh(double __x) __CONSTATTR;

#ifdef	__USE_MISC
extern __CONSTVALUE double acosh(double __x) __CONSTATTR;
extern __CONSTVALUE double asinh(double __x) __CONSTATTR;
extern __CONSTVALUE double atanh(double __x) __CONSTATTR;
#endif

extern __CONSTVALUE double exp(double __x) __CONSTATTR;
extern double frexp(double __value, int *__exp);
extern __CONSTVALUE double ldexp(double __x, int __exp) __CONSTATTR;
extern __CONSTVALUE double log(double __x) __CONSTATTR;
extern __CONSTVALUE double log10(double __x) __CONSTATTR;

#ifdef	__USE_MISC
extern __CONSTVALUE double expm1(double __x) __CONSTATTR;
extern __CONSTVALUE double log1p(double __x) __CONSTATTR;
#endif

extern double modf(double __value, double *__iptr);

extern __CONSTVALUE double pow(double __x, double __y) __CONSTATTR;
extern __CONSTVALUE double sqrt(double __x) __CONSTATTR;
extern __CONSTVALUE double ceil(double __x) __CONSTATTR;
extern __CONSTVALUE double fabs(double __x) __CONSTATTR;
extern __CONSTVALUE double floor(double __x) __CONSTATTR;
extern __CONSTVALUE double fmod(double __x, double __y) __CONSTATTR;

     /* Private */
#define __scalb ldexp
extern __inline__ __CONSTVALUE double __copysign(double x, double y)
     __CONSTATTR;

extern __inline__ __CONSTVALUE double __copysign(double x, double y)
{
  return __extension__
    ({
      union {double d; struct { int mant : 31; unsigned sign : 1;}s;}
      _dlx = { d:x },_dly= { d:y };
      _dlx.s.sign = _dly.s.sign;
      _dlx.d;
    });
}

extern __inline__ __CONSTVALUE int __isnan(double x) __CONSTATTR;
extern __inline__ __CONSTVALUE int __isnan(double x)
{
  return __extension__
    ({
      union {double d; struct { int mant : 23; unsigned exp : 8; unsigned sign : 1;}s;}
      _x = { d : x};
      (_x.s.exp == 0xff) && _x.s.mant != 0;
    });
}


extern __inline__ __CONSTVALUE int __isinf(double x) __CONSTATTR;
extern __inline__ __CONSTVALUE int __isinf(double x) 
{
  return __extension__
    ({
      union {double d; struct { int mant : 23; unsigned exp : 8; unsigned sign : 1;}s;}
      _x = { d : x};
      (_x.s.exp != 0xff)
        ? 0 : _x.s.sign ? -1 : 1;
    });
}

extern __inline__ __CONSTVALUE int __finite(double x) __CONSTATTR;
extern __inline__ __CONSTVALUE int __finite(double x)
{ return !__isinf(x) && !__isnan(x);}

#endif	/* math.h  */
