/* This file has been modified for CRIS.  See the README file of this distribution. */
/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <errno.h>
#include <math.h>

/* See how to declare a "constant" function (given same parameters
   will always return same value) */
#if (__GNUC__ >= 2) && (__GNUC_MINOR__ >= 6)
#define CONSTF
#define CONSTA __attribute((const))
#else
#define CONSTF const
#define CONSTA
#endif

extern CONSTF double __logb(double) CONSTA;

/* Break VALUE into a normalized fraction and an integral power of 2.  */
double frexp(double value, int *exp)
{
  /* Add one to the exponent of the number,
     so we have one digit before the binary point.  */
  *exp = (int) __logb (value) + 1;
  return ldexp (value, - *exp);
}
