/* This file has been modified for CRIS.  See the README file of this distribution. */
/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <math.h>
#include "ieee754.h"

/* Return nonzero if VALUE is not a number.  */
int __isnan (double value)
{
  union ieee754_double u;

  u.d = value;

  /* IEEE 754 NaN's have the maximum possible
     exponent and a nonzero mantissa.  */
  return (u.ieee.exponent == 0xff &&
	  u.ieee.mantissa != 0);
}
