/*
** libgcc support for software floating point.
** Copyright (C) 1991 by Pipeline Associates, Inc.  All rights reserved.
** Permission is granted to do *anything* you want with this file,
** commercial or otherwise, provided this message remains intact.  So there!
** I would appreciate receiving any updates/patches/changes that anyone
** makes, and am willing to be the repository for said changes (am I
** making a big mistake?).

Warning! Only single-precision is actually implemented.  This file
won't really be much use until double-precision is supported.

However, once that is done, this file might eventually become a
replacement for libgcc1.c.  It might also make possible
cross-compilation for an IEEE target machine from a non-IEEE
host such as a VAX.

If you'd like to work on completing this, please talk to rms@gnu.ai.mit.edu.


**
** Pat Wood
** Pipeline Associates, Inc.
** pipeline!phw@motown.com or
** sun!pipeline!phw or
** uunet!motown!pipeline!phw
**
** 05/01/91 -- V1.0 -- first release to gcc mailing lists
** 05/04/91 -- V1.1 -- added float and double prototypes and return values
**                  -- fixed problems with adding and subtracting zero
**                  -- fixed rounding in truncdfsf2
**                  -- fixed SWAP define and tested on 386
** 11/18/92 -- V1.2 HP fixed return types.  Other bugs squashed.  Code hacked.
**                     The code now (almost) passes enquire, except
**                     you need some good strtod() function that
**                     accepts that float=double and knows how to
**                     minimize roundoff errors.
** 12/07/95 -- V1.3 HP Fixed GIANT BUG! infinite loop on -0 !
**                     Changed some newbie slash-asterisk removed-code
**                     into "#if 0":s 
** 01/06/96 -- V1.4 HP Round result from floatsisf()
** 03/20/97 -- V1.5 HP Bug with both numbers negative in __cmpsf()
*/
#include <math.h>
#define SWAP 1

/*
** The following are routines that replace the libgcc soft floating point
** routines that are called automatically when -msoft-float is selected.
** The support single and double precision IEEE format, with provisions
** for byte-swapped machines (tested on 386).  Some of the double-precision
** routines work at full precision, but most of the hard ones simply punt
** and call the single precision routines, producing a loss of accuracy.
** long long support is not assumed or included.
** Overall accuracy is close to IEEE (actually 68882) for single-precision
** arithmetic.  I think there may still be a 1 in 1000 chance of a bit
** being rounded the wrong way during a multiply.  I'm not fussy enough to
** bother with it, but if anyone is, knock yourself out.
**
** Efficiency has only been addressed where it was obvious that something
** would make a big difference.  Anyone who wants to do this right for
** best speed should go in and rewrite in assembler.
**
** I have tested this only on a 68030 workstation and 386/ix integrated
** in with -msoft-float.
*/

/* the following deal with IEEE single-precision numbers */
#define EXCESS		126
#define SIGNBIT		0x80000000U
#define HIDDEN		(1 << 23)
#define SIGN(fp)	((fp) & SIGNBIT)
#define EXP(fp)		(((fp) >> 23) & 0xFF)
#define MANT(fp)	(((fp) & 0x7FFFFF) | (EXP(fp) == 0 ? 0 : HIDDEN))
#define PACK(s,e,m)	((s) | ((e) << 23) | (m))

/* Use this instead of "!f.l" when checking for zero, otherwise you
   will miss -0 !! */ 
#define IS_FZERO(fp)           (((fp)&~SIGNBIT) == 0)

/* the following deal with IEEE double-precision numbers */
#if 0
#define EXCESSD		1022
#define HIDDEND		(1 << 20)
#define EXPD(fp)	(((fp.l.upper) >> 20) & 0x7FF)
#define SIGND(fp)	((fp.l.upper) & SIGNBIT)
#define MANTD(fp)	(((((fp.l.upper) & 0xFFFFF) | HIDDEND) << 10) | \
				(fp.l.lower >> 22))
#endif

/* See how to declare a "constant" function (given same parameters
   will always return same value) */
#if (__GNUC__ >= 2) && (__GNUC_MINOR__ >= 6)
#define CONSTF
#define CONSTA __attribute((const))
#else
#define CONSTF const
#define CONSTA
#endif

/* define SWAP for 386/960 reverse-byte-order brain-damaged CPUs */
union double_long
  {
    double d;
#ifdef SWAP
    struct {
      unsigned long lower;
      long upper;
    } l;
#else
    struct {
      long upper;
      unsigned long lower;
    } l;
#endif
  };

union float_long
  {
    float f;
    long l;
  };

#ifdef TESTSF
#include "simcodes.h"
#include <stdio.h>

#define DB(a) do { long _dbl = (a); \
                     __asm__ volatile ("bmod [%0],%1" :: \
                                       "r" (S_debug), "r" (_dbl)); } while (0)
extern CONSTF float
__addsf3 (float a1, float a2) CONSTA;

CONSTF float
__addsf3 (float a1, float a2)
#define __addsf3 __Addsf3
{
  union float_long a1b,a2b,res;
  
  extern CONSTF float
    __addsf3 (float a1, float a2) CONSTA;

  a1b.f = a1; a2b.f = a2;

  DB(1);
  DB(a1b.l);
  DB(a2b.l);
  res.f = __addsf3(a1, a2);
  DB(res.l);

  return res.f;
}

extern CONSTF /* subtract two floats */
float
__subsf3 (float a1, float a2) CONSTA;

CONSTF /* subtract two floats */
float
__subsf3 (float a1, float a2)
#define __subsf3 __Subsf3
{
  union float_long a1b,a2b,res;
  
  extern CONSTF /* subtract two floats */
    float
      __subsf3 (float a1, float a2) CONSTA;

  a1b.f = a1; a2b.f = a2;

  DB(2);
  DB(a1b.l);
  DB(a2b.l);
  res.f = __subsf3(a1, a2);

  DB(res.l);
  return res.f;
}

extern CONSTF long
__cmpsf2 (float a1, float a2) CONSTA;

CONSTF long
__cmpsf2 (float a1, float a2)
#define __cmpsf2 Cmpsf2
{
  union float_long a1b,a2b,res;
  
  extern CONSTF long
    __cmpsf2 (float a1, float a2) CONSTA;

  a1b.f = a1; a2b.f = a2;

  DB(3);
  DB(a1b.l);
  DB(a2b.l);

  res.l = __cmpsf2(a1, a2);
  DB(res.l);


  return res.l;
}

extern CONSTF float
__mulsf3 (float a1, float a2) CONSTA;

CONSTF float
__mulsf3 (float a1, float a2)
#define __mulsf3 __Mulsf3
{
  union float_long a1b,a2b,res;
  
  extern CONSTF float
    __mulsf3 (float a1, float a2) CONSTA;

  a1b.f = a1; a2b.f = a2;

  DB(4);
  DB(a1b.l);
  DB(a2b.l);
  res.f = __mulsf3(a1, a2);
  DB(res.l);

  return res.f;
}

extern CONSTF float
__divsf3 (float a1, float a2) CONSTA;

CONSTF float
__divsf3 (float a1, float a2)
#define __divsf3 __Divsf3
{
  union float_long a1b,a2b,res;
  
  extern CONSTF float
    __divsf3 (float a1, float a2) CONSTA;

  a1b.f = a1; a2b.f = a2;

  DB(5);
  DB(a1b.l);
  DB(a2b.l);

  res.f = __divsf3(a1, a2);

  DB(res.l);

  return res.f;
}

CONSTF float
__floatsisf(long a1) CONSTA;

CONSTF float
__floatsisf(long a1)
#define __floatsisf __Floatsisf
{
  union float_long a1b,res;
  
  extern CONSTF float
    __floatsisf(long a1) CONSTA;

  DB(6);
  DB(a1);

  res.f = __floatsisf(a1);

  DB(res.l);

  return res.f;
}

extern CONSTF long
__fixsfsi(float a1) CONSTA;

CONSTF long
__fixsfsi(float a1)
#define __fixsfsi __Fixsfsi
{
  union float_long a1b,res;

  extern CONST long
    __fixsfsi(float a1) CONSTA;

  a1b.f = a1;

  DB(7);
  DB(a1b.l);

  res.l = __fixsfsi(a1);
  
  DB(res.l);

  return res.l;
}

#endif /* TESTSF */

/* add two floats */
extern  __inline__ CONSTF float          /* Make it inline-expanded in subsf */
__addsf3 (float a1, float a2) CONSTA;

__inline__ CONSTF float          /* Make it inline-expanded in subsf */
__addsf3 (float a1, float a2)
{
  register long mant1, mant2;
  register union float_long fl1, fl2;
  register int exp1, exp2;
  int sign = 0;

  fl1.f = a1;
  fl2.f = a2;

  /* check for zero args */
  if (IS_FZERO(fl1.l))
    return (fl2.f);
  if (IS_FZERO(fl2.l))
    return (fl1.f);

  if (!__finite(fl1.f))
    return fl1.f;
  if (!__finite(fl2.f))
    return fl2.f;

  exp1 = EXP (fl1.l);
  exp2 = EXP (fl2.l);

  if (exp1 > exp2 + 25)
    return (fl1.f);
  if (exp2 > exp1 + 25)
    return (fl2.f);

  /* do everything in excess precision so's we can round later */
  mant1 = MANT (fl1.l) << 6;
  mant2 = MANT (fl2.l) << 6;

  if (SIGN (fl1.l))
    mant1 = -mant1;
  if (SIGN (fl2.l))
    mant2 = -mant2;

  if (exp1 > exp2)
    {
      mant2 >>= exp1 - exp2;
    }
  else
    {
      mant1 >>= exp2 - exp1;
      exp1 = exp2;
    }
  mant1 += mant2;

  if (mant1 < 0)
    {
      mant1 = -mant1;
      sign = SIGNBIT;
    }
  else if (!mant1)
    return (0);

  if (exp1 > 0) {
    /* normalize up */
    while (!(mant1 & 0xE0000000))
      {
	mant1 <<= 1;
	exp1--;
      }
  }    

  /* normalize down? */
  while (mant1 & (1 << 30))
    {
      mant1 >>= 1;
      exp1++;
    }

  /* round to even */
  mant1 += (mant1 & 0x40) ? 0x20 : 0x1F;

  /* normalize down? */
  if (mant1 & (1 << 30))
    {
      mant1 >>= 1;
      exp1++;
    }

  if (exp1 > 254) {
    return __extension__
      ({
        union float_long fl = { l: (sign|0x7f800000)};
        fl.f;
      });
  } else if (exp1 < 0) {
    mant1 >>= -exp1;
    exp1 = 0;
  } 

  if (exp1 == 0)
    mant1 >>= 1;

  /* lose extra precision */
  mant1 >>= 6;

  /* turn off hidden bit */
  mant1 &= ~HIDDEN;

  /* pack up and go home */
  fl1.l = PACK (sign, exp1, mant1);
  return (fl1.f);
}

extern CONSTF /* subtract two floats */
float
__subsf3 (float a1, float a2) CONSTA;

CONSTF /* subtract two floats */
float
__subsf3 (float a1, float a2)
{
  register union float_long fl1, fl2;

  fl1.f = a1;
  fl2.f = a2;

  if (IS_FZERO(fl2.l))
  {
    return a1;
  }

  /* twiddle sign bit and add */
  fl2.l ^= SIGNBIT;
  return __addsf3 (a1, fl2.f);
}

/* compare two floats */
extern __inline__ CONSTF long
__cmpsf2 (float a1, float a2) CONSTA;

__inline__ CONSTF long
__cmpsf2 (float a1, float a2)
{
  register union float_long fl1, fl2;

  fl1.f = a1;
  fl2.f = a2;

  if (__isinf(fl1.f))
    return SIGN(fl1.l) ? -1 : 1;
  if (__isinf(fl2.f))
    return SIGN(fl2.l) ? 1 : -1;

  if ((fl1.l & 0x7fffffff) == 0)
    fl1.l = 0;

  if ((fl2.l & 0x7fffffff) == 0)
    fl2.l = 0;

  if (SIGN (fl1.l) && SIGN (fl2.l))
    {
      union float_long fltmp;

      fl1.l ^= SIGNBIT;
      fl2.l ^= SIGNBIT;

      /* Swap them, or it will be the reverse result. */
      fltmp.l = fl1.l;
      fl1.l = fl2.l;
      fl2.l = fltmp.l;
    }

  if (__isinf(fl1.f))
    return SIGN(fl1.l) ? -1 : 1;
  if (__isinf(fl2.f))
    return SIGN(fl2.l) ? 1 : -1;

  if (fl1.l < fl2.l)
    return (-1);
  if (fl1.l > fl2.l)
    return (1);
  return (0);
}

/* multiply two floats */
extern CONSTF float
__mulsf3 (float a1, float a2) CONSTA;

CONSTF float
__mulsf3 (float a1, float a2)
{
  register union float_long fl1, fl2;
  register unsigned long result;
  register int exp;
  int sign;

  fl1.f = a1;
  fl2.f = a2;

  if (!__finite(fl1.f))
    return fl1.f;
  if (!__finite(fl2.f))
    return fl2.f;

  /* compute sign and exponent */
  sign = SIGN (fl1.l) ^ SIGN (fl2.l);

  /* Seems like X*0, where X<0 is -0 */
  if (IS_FZERO(fl1.l) || IS_FZERO(fl2.l))
    return ((union float_long) ((long) sign)).f;

  exp = EXP (fl1.l) - EXCESS;
  exp += EXP (fl2.l);

  fl1.l = MANT (fl1.l);
  fl2.l = MANT (fl2.l);

  while ((fl1.l & 0x800000) == 0)
    fl1.l <<= 1,exp--;

  while ((fl2.l & 0x800000) == 0)
    fl2.l <<= 1,exp--;

  /* the multiply is done as one 16x16 multiply and two 16x8
  multiples */
  result = (fl1.l >> 8) * (fl2.l >> 8);
  result += ((fl1.l & 0xFF) * (fl2.l >> 8)) >> 8;
  result += ((fl2.l & 0xFF) * (fl1.l >> 8)) >> 8;

  if (result & 0x80000000)
    {
      /* round */
      result += 0x80;
      result >>= 8;
    }
  else
    {
      /* round */
      result += 0x40;
      result >>= 7;
      exp--;
    }

  while (result >= 0x1000000)
    result >>= 1,exp++;
  while (result < 0x800000)
    result <<= 1,exp--;
    
  if (exp > 254) {
    return __extension__
      ({
        union float_long fl = {l : (sign|0x7f800000)};
        fl.f;
      });
  }
  else if (exp < 0) {
    if (exp < -24)
      return ((union float_long) ((long) sign)).f;
    result >>= -exp;
    exp = 0;
  }
  if (exp == 0)
    result >>= 1;

  result &= ~HIDDEN;

  /* pack up and go home */
  fl1.l = PACK (sign, exp, result);
  return (fl1.f);
}

/* divide two floats */
extern CONSTF float
__divsf3 (float a1, float a2) CONSTA;

CONSTF float
__divsf3 (float a1, float a2)
{
  register union float_long fl1, fl2;
  register int result;
  register int mask;
  register int exp, sign;

  fl1.f = a1;
  fl2.f = a2;

  if (__isinf(fl1.f)) {
    fl1.l ^= SIGN(fl2.l);
    return fl1.f;
  }

  if (__isinf(fl2.f)) {
    return ((union float_long) (long) ((SIGN(fl2.l)^SIGN(fl1.l)))).f;
  }

  /* subtract exponents */
  exp = EXP (fl1.l) - EXP (fl2.l) + EXCESS;

  /* compute sign */
  sign = SIGN (fl1.l) ^ SIGN (fl2.l);

  /* divide by zero??? */
  if (IS_FZERO(fl2.l))
    /* return Inf or -Inf */
    return ((union float_long) ((long) (sign|0x7f800000))).f;

  /* numerator zero??? */
  if (IS_FZERO(fl1.l))
    return ((union float_long) ((long) (sign))).f;              /* may be -0 */

  /* now get mantissas */
  fl1.l = MANT (fl1.l);
  fl2.l = MANT (fl2.l);

  while ((fl1.l & 0x800000) == 0)
    fl1.l <<= 1,exp--;

  while ((fl2.l & 0x800000) == 0)
    fl2.l <<= 1,exp--;

  /* this assures we have 25 bits of precision in the end */
  if (fl1.l < fl2.l)
    {
      fl1.l <<= 1;
      exp--;
    }

  /* now we perform repeated subtraction of fl2.l from fl1.l */
  mask = 0x1000000;
  result = 0;
  while (mask)
    {
      if (fl1.l >= fl2.l)
	{
	  result |= mask;
	  fl1.l -= fl2.l;
	}
      fl1.l <<= 1;
      mask >>= 1;
    }

  /* round */
  result += 1;

  /* normalize down */
  exp++;
  result >>= 1;

  if (exp > 254) {
    return __extension__
      ({
        union float_long fl = {l : (sign|0x7f800000)};
        fl.f;
      });
  }
  else if (exp < 0) {
    if (exp < -24)
      return ((union float_long) ((float) sign)).f;
    result >>= -exp;
    exp = 0;
  }

  if (exp == 0)
    result >>= 1;

  result &= ~HIDDEN;

  /* pack up and go home */
  fl1.l = PACK (sign, exp, result);
  return (fl1.f);
}

/* convert int to double */
#if 0
 double
__floatsidf (register long a1)
{
  register int sign = 0, exp = 31 + EXCESSD;
  union double_long dl;

  if (!a1)
    {
      dl.l.upper = dl.l.lower = 0;
      return (dl.d);
    }

  if (a1 < 0)
    {
      sign = SIGNBIT;
      a1 = -a1;
    }

  while (a1 < 0x1000000)
    {
      a1 <<= 4;
      exp -= 4;
    }

  while (a1 < 0x40000000)
    {
      a1 <<= 1;
      exp--;
    }

  /* pack up and go home */
  dl.l.upper = sign;
  dl.l.upper |= exp << 20;
  dl.l.upper |= (a1 >> 10) & ~HIDDEND;
  dl.l.lower = a1 << 22;

  return (dl.d);
}
#endif

/* negate a float */
extern CONSTF float
__negsf2 (float a1) CONSTA;

CONSTF float
__negsf2 (float a1)
{
  register union float_long fl1;

  fl1.f = a1;

  /* No need to check for zero... we will accept -0 */
#if 0
  if (!fl1.l)
    return (0);
#endif

  fl1.l ^= SIGNBIT;
  return (fl1.f);
}

/* negate a double */
#if 0
 double
__negdf2 (double a1)
{
  register union double_long dl1;

  dl1.d = a1;

  if (!dl1.l.upper && !dl1.l.lower)
      return (dl1.d);

  dl1.l.upper ^= SIGNBIT;
  return (dl1.d);
}
#endif
/* convert float to double */

#if 0
 double
__extendsfdf2 (float a1)
{
  register union float_long fl1;
  register union double_long dl;
  register int exp;

  fl1.f = a1;

  if (!fl1.l)
    {
      dl.l.upper = dl.l.lower = 0;
      return (dl.d);
    }

  dl.l.upper = SIGN (fl1.l);
  exp = EXP (fl1.l) - EXCESS + EXCESSD;
  dl.l.upper |= exp << 20;
  dl.l.upper |= (MANT (fl1.l) & ~HIDDEN) >> 3;
  dl.l.lower = MANT (fl1.l) << 29;

  return (dl.d);
}
#endif

/* convert double to float */

#if 0
 float
__truncdfsf2 (double a1)
{
  register int exp;
  register long mant;
  register union float_long fl;
  register union double_long dl1;

  dl1.d = a1;

  if (!dl1.l.upper && !dl1.l.lower)
    return (0);

  exp = EXPD (dl1) - EXCESSD + EXCESS;

  /* shift double mantissa 6 bits so we can round */
  mant = MANTD (dl1) >> 6;

  /* now round and shift down */
  mant += 1;
  mant >>= 1;

  /* did the round overflow? */
  if (mant & 0xFF000000)
    {
      mant >>= 1;
      exp++;
    }

  mant &= ~HIDDEN;

  /* pack up and go home */
  fl.l = PACK (SIGND (dl1), exp, mant);
  return (fl.f);
}
#endif

/* compare two doubles */

#if 0
 long
__cmpdf2 (double a1, double a2)
{
  register union double_long dl1, dl2;

  dl1.d = a1;
  dl2.d = a2;

  if (SIGND (dl1) && SIGND (dl2))
    {
      dl1.l.upper ^= SIGNBIT;
      dl2.l.upper ^= SIGNBIT;
    }
  if (dl1.l.upper < dl2.l.upper)
    return (-1);
  if (dl1.l.upper > dl2.l.upper)
    return (1);
  if (dl1.l.lower < dl2.l.lower)
    return (-1);
  if (dl1.l.lower > dl2.l.lower)
    return (1);
  return (0);
}

/* convert double to int */
 long
__fixdfsi (double a1)
{
  register union double_long dl1;
  register int exp;
  register long l;

  dl1.d = a1;

  if (!dl1.l.upper && !dl1.l.lower)
    return (0);

  exp = EXPD (dl1) - EXCESSD - 31;
  l = MANTD (dl1);

  if (exp > 0)
    return (0x7FFFFFFF | SIGND (dl1)); /* largest integer */

  /* shift down until exp = 0 or l = 0 */
  if (exp < 0 && exp > -32 && l)
    l >>= -exp;
  else
    return (0);

  return (SIGND (dl1) ? -l : l);
}
#endif

/* convert double to unsigned int */

#if 0
 unsigned
long __fixunsdfsi (double a1)
{
  register union double_long dl1;
  register int exp;
  register unsigned long l;

  dl1.d = a1;

  if (!dl1.l.upper && !dl1.l.lower)
    return (0);

  exp = EXPD (dl1) - EXCESSD - 32;
  l = (((((dl1.l.upper) & 0xFFFFF) | HIDDEND) << 11) | (dl1.l.lower >> 21));

  if (exp > 0)
    return (0xFFFFFFFF);	/* largest integer */

  /* shift down until exp = 0 or l = 0 */
  if (exp < 0 && exp > -32 && l)
    l >>= -exp;
  else
    return (0);

  return (l);
}
#endif

/* For now, the hard double-precision routines simply
   punt and do it in single */
/* addtwo doubles */

#if 0
 double
__adddf3 (double a1, double a2)
{
  return ((float) a1 + (float) a2);
}

/* subtract two doubles */
 double
__subdf3 (double a1, double a2)
{
  return ((float) a1 - (float) a2);
}

/* multiply two doubles */
 double
__muldf3 (double a1, double a2)
{
  return ((float) a1 * (float) a2);
}

/* divide two doubles */
 double
__divdf3 (double a1, double a2)
{
  return ((float) a1 / (float) a2);
}
#endif

extern CONSTF float
__floatsisf(long a1) CONSTA;

CONSTF float
__floatsisf(long a2)
{
  register int sign=0, exp=31+EXCESS;
  union float_long fl;

  unsigned long a1;

  if (!a2)
    {
      fl.l = 0;
      return (fl.f);
    }

  if (a2 < 0)
    {
      sign = SIGNBIT;
      a1 = -a2;
    }
  else
    {
      a1 = a2;
    }

  while (a1 < 0x1000000)
    {
      a1 <<= 4;
      exp -= 4;
    }

  while (a1 < 0x40000000)
    {
      a1 <<= 1;
      exp--;
    }

  /* Round result */
  a1 += 0x40;
  /* If we went overboard, adjust exp & mantissa */
  if (a1 & 0x80000000)
  {
    a1 >>= 1;
    exp++;
  }

  /* pack up and go home */
  fl.l = sign;
  fl.l |= exp << 23;
  fl.l |= (a1 >> 7) & ~HIDDEN;

  return (fl.f);
}

extern CONSTF long
__fixsfsi(float a1) CONSTA;

CONSTF long
__fixsfsi(float a1)
{
  register union float_long fl1;
  register int exp;
  register long l;

  fl1.f = a1;

  if (IS_FZERO(fl1.l))
    return (0);

  exp = EXP (fl1.l) - EXCESS;
  l = MANT (fl1.l);

  /* We should handle 0x80000000 too, although we strictly dont have to. */
  if (exp > 31) 
  {
    if (exp == 32 && l == 0x800000)
      return 0x80000000;
    return (0x7FFFFFFF | SIGN (fl1.l)); /* largest integer */
  }
  /* shift down until exp = 0 or l = 0 */
  if (exp < 0 || !l)
    return 0;
  if (exp < 24)
    l >>= (24 - exp);
  else
    l <<= (exp - 24);

  return (SIGN (fl1.l) ? -l : l);
}

extern CONSTF int
__nesf2(float a,float b) CONSTA;

CONSTF int
__nesf2(float a,float b) 
{
  int i = __cmpsf2(a,b);
  return (i != 0);
}

extern CONSTF int
__lesf2(float a,float b) CONSTA;

CONSTF int
__lesf2(float a,float b) 
{
  int i = __cmpsf2(a,b);
  return 1-(i <= 0);
}

extern CONSTF int
__ltsf2(float a,float b) CONSTA;

CONSTF int
__ltsf2(float a,float b) 
{
  int i = __cmpsf2(a,b);
  return -(i < 0);
}

extern CONSTF int
__gesf2(float a,float b) CONSTA;

CONSTF int
__gesf2(float a,float b) 
{
  int i = __cmpsf2(a,b);
  return (i >= 0)-1;
}

extern CONSTF int
__gtsf2(float a,float b) CONSTA;

CONSTF int
__gtsf2(float a,float b) 
{
  int i = __cmpsf2(a,b);
  return (i > 0);
}

extern CONSTF int
__eqsf2(float a,float b) CONSTA;

CONSTF int
__eqsf2(float a,float b) 
{
  int i = __cmpsf2(a,b);
  return !(i == 0);
}
