/* ctype.h for cris */

#ifndef __Ctype_h_
#define __Ctype_h_
extern const short _Tolow_tab[];
extern const short _Toup_tab[];
extern const short _Ctype[];
#define _XA		0x200 /* extra alphabetic */
#define _XS		0x100 /* extra space */
#define _BB		0x80 /* BEL, BS, etc. */
#define _CN		0x40 /* CR, FF, HT, NL, VT */
#define _DI		0x20 /* '0'-'9' */
#define _LO		0x10 /* 'a'-'z' */
#define _PU		0x08 /* punctuation */
#define _SP		0x04 /* space */
#define _UP		0x02 /* 'A'-'Z' */
#define _XD		0x01 /* '0'-'9', 'A'-'F', 'a'-'f' */

#undef EOF
#define EOF (-1)

#define isalnum(c)	(_Ctype[(unsigned char)(c)] & (_DI|_LO|_UP|_XA))
#define isalpha(c)	(_Ctype[(unsigned char)(c)] & (_LO|_UP|_XA))
#define iscntrl(c)	(_Ctype[(unsigned char)(c)] & (_BB|_CN))
#define isdigit(c)	(_Ctype[(unsigned char)(c)] & _DI)
#define isgraph(c)	(_Ctype[(unsigned char)(c)] & (_DI|_LO|_PU|_UP|_XA))
#define islower(c)	(_Ctype[(unsigned char)(c)] & _LO)
#define isprint(c)	\
	(_Ctype[(unsigned char)(c)] & (_DI|_LO|_PU|_SP|_UP|_XA))
#define ispunct(c)	(_Ctype[(unsigned char)(c)] & _PU)
#define isspace(c)	(_Ctype[(unsigned char)(c)] & (_CN|_SP|_XS))
#define isupper(c)	(_Ctype[(unsigned char)(c)] & _UP)
#define isxdigit(c)	(_Ctype[(unsigned char)(c)] & _XD)
#define tolower(c) __extension__ ({ \
	     int _I1 = (c);  \
	     _I1 == EOF ? 0 : _Tolow_tab[(unsigned char) _I1];})

#define toupper(c) __extension__ ({ \
	     int _I1 = (c);  \
	     _I1 == EOF ? 0 : _Toup_tab[(unsigned char) _I1];})

#endif /* ?included */
