/* C base for the startuproutine to be located at addr 0.
 
    This really shouldnt be used on a real embedded system.
    It is more for use when you do new hardware, and want a quick fix
    to run your main() loop for a test program.

     Please write you own since this doesnt take hardware
    considerations in account. 

*/
#include <stdio.h>

/* Simulator definitions.  Nothing in the real thing should depend on this. */
#include "simcodes.h"

/* Somebody might be messing with us. */
#undef asm

/* Number of used files. */
extern int _Filenos;

/* The files themselves.  CRIS "FILE"s are mainly big-endian "FILE *"s 
   in the sparc address space.  For CRIS, they are just mumbojumbo
   numbers.  Of course you have to make a new crt0.c in case you
   create a real filesystem. */
extern FILE _Files[];

/* The environment pointer; the seldom-used third argument to main(). */
char *_Environ;

/* Argument 2 to main(). */
char **_Argv;

/* Argument 1 to main(). */
int _Argc;

void _start(void);

/* Returnvalue from exit(). */
static int _Exit_stat=0;

/* (Could be done more gracefully). */
static long tmp = S_exit;

/* atexit() functions count stored here. */
size_t _Atcount = 32;

/* If you write an interrupt routine, there must be a corresponding 
   "const char _Do_interrupt = TRUE;" in your interrupt-routine, or
   there will be linked in a default "const char _Do_interrupt = FALSE;"
   from the libraries. */
extern const char _Do_interrupt;

/* atexit() functions stored here. */
void (*_Atfuns[32])(void);

/* This is located at address 0. */
void start(void)
{
  __asm__ volatile(".word 39");	/* Configuration word, magic for rsim. */
  __asm__ volatile ("ba __stackload");	/* Skip interrupt vectors. */
  __asm__ volatile ("nop
Here_is_int2_vector:");
  __asm__ volatile(".dword int2");	/* Only vectors 2..255 are useful for IRQ. */
  __asm__ volatile(".dword int2");	/* In MY interrupt code, the vectors
                                           all point to the same code, which
                                           determines the priority order, and
                                           which interrupts were issued. */
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");
  __asm__ volatile(".dword int2");

/* End of IRQ vectors */

  __asm__ volatile("__stackload:");
  __asm__ volatile("  move.d 0x4001fffe,sp");
  __asm__ volatile (" ba __start");	/* Skip interrupt vectors. */
  __asm__ volatile (" nop");

}

/* This is a template on how to write a dummy-shell for an interrupt
   routine (the address the vectors point at). */
void _Dummy_int(void)
{
  /* The "_INTERRUPT" symbol is for "simfix" so we can easily see when 
     there is an interrupt. */
  __asm__ volatile ("
        .global _INTERRUPT
int2:
	push irp ; Really only needed if you expect nested interrupts
_INTERRUPT:
        push ccr ; Must be done
        push srp ; Only needed if you want to call subroutines. Who doesnt?
        di       ; Must be done, else you will end up out of stack...
        subq 14*4,sp ; Allocate stack to save registers
        movem r13,[sp] ; Well, you normally (from C) only need save r9..r13
        move.d _intr_routine_ptr,r0
        jsr     [r0]
        movem [sp+],r13 ; Restore registers
        ei       ; Re-enable interrupts (not needed - pop ccr below)
        pop srp  ; Restore any return address for the interrupted routine
        pop ccr  ; Restore flags
        jump [sp+]");		/* Return to the interrupted */
}


/* This function is where we jump just before main(). */
void _start(void)
{
  int i;

  /** All is setup in the simulator:

   * Reasonable stack for sp
     (very important; so we can split this file into routines!) 

   * Argument counter to r10

   * Argument vector to r11

   * Environment to r12

   * stdin, stdout, stderr in r0,r1,r2

   Remember to check the assembler output so it has not clobbered
    crucial registers, or ANYTHING.

   */
  /* These registers MUST not have been clobbered between addr 2 and here. */
  __asm__ volatile("move.d r0,[__Files]"); /* Stdin, handle 0 */
  __asm__ volatile("move.d r1,[__Files+4]"); /* Stdout, handle 1 */
  __asm__ volatile("move.d r2,[__Files+8]"); /* Stderr handle 2 */
  __asm__ volatile("move.d r10,[__Argc]"); 
  __asm__ volatile("move.d r11,[__Argv]");
  __asm__ volatile("move.d r12,[__Environ]");

  /* Clear the files (not stdin, stdout,stderr) */
  for (i = 3; i < 32; i++)
    _Files[i] = 0;

  /* The standard files are always open. */
  _Filenos = 3;

  /* This is just a call to memcpy, but im too lazy to extern Sdata etc.  */
  __asm__ volatile("
  move.d __Sdata,r10
  move.d _etext,r11
  cmp.d r11,r10                 ; Do not copy if areas are the same.
  beq 0f
  nop

  move.d _edata,r12		; You cannot move.d _edata-__Sdata,r12
  sub.d __Sdata,r12		; because as+ld has got a hole in the head.
  jsr _memcpy
0:
  move.d __end,r12              ; Better clear bss, or we will be sorry.
  clear.d r11
  move.d _bss_start,r10
  sub.d r10,r12
  jsr _memset
");

  /* If we havent linked in any interrupt routine, then dont do interrupts.
     the interrupt_routine() and _Do_interrupt = 0 dummys are in int.c */
  if (_Do_interrupt)
    __asm__ volatile ("ei");


  /* Do the real stuff. */
  main(_Argc,_Argv,_Environ);

  /* We arrive here at "call" from exit(), or at return from main() */
  __asm__ volatile(".global __exit\n__exit:\n\tmove.d r10,[__Exit_stat]");

  /* Close any open files. */
  for (i = 3; i < 32; i++)
    if (_Files[i])
      fclose(_Files+i);


  /* This maybe could be done more gracefully.
     It is the entry from "call" to abort(). */
  __asm__ volatile
    ("
	move.d [__Exit_stat],r10
	.global __Exit
__Exit:
	move.d [_tmp],r11
	bmod [r11],r10
__Forever: ba __Forever
");

}

/* This is called from exit(), I think. */
void _cleanup(void) {
  int i = 32;
  
  /* Call the atexit() functions in opposite order from when attached. */
  while (i > _Atcount)
    (_Atfuns[--i])();
}
