#
# Second part of Makefile for libc, headers and crt0 for CRIS.
#
# libc.a is the library for a "real" libc.a, while
# libsc.a is the complete library for a simulator version.
#
#  The distinction is that libc.a lacks some functions; you
# rarely have filesystems is an embedded application.
#
# libm.a is a couple of mathematics functions not ANSII but should be.
#
# "headers" are all the ANSII headers necessary.
#
# crt0.o is what you need to debug your new system (do not use it in
#        the production, it is not optimal in any sense but
#        time-to-object-code).
#
# scrt0.o is what you need from reset to main() NOTE! THIS VERSION WILL
#                                              ONLY WORK IN THE rsim/xsim SIMULATOR!
#
# vcrt0.o is more close to the real thing BUT STILL VARIABLES ARE NOT
#                                         INITIALIZED! 
#
# These crt0 routines are only meant to work in various simulators.
#

# Do not add ANY assembler files here, please.  They are assumed being
# temporary files.  There are no actual assembler source files here.

# These variables must all be overridden by the calling "make".
dirprefix=_must_be_overridden_by_Makefile
installdir=_must_be_overridden_by_Makefile
includedir=_must_be_overridden_by_Makefile
bindir=_must_be_overridden_by_Makefile
CC=_must_be_overridden_by_Makefile
CFLAGS=_must_be_overridden_by_Makefile
CPPFLAGS=_must_be_overridden_by_Makefile
AR=_must_be_overridden_by_Makefile
RANLIB=_must_be_overridden_by_Makefile
ARFLAGS=_must_be_overridden_by_Makefile

CFILES=abort.c atexit.c atof.c atoi.c version.c \
atol.c bsearch.c calloc.c div.c \
free.c getenv.c ldiv.c \
malloc.c qsort.c rand.c realloc.c \
srand.c strtod.c strtol.c strtoul.c \
system.c memchr.c memcmp.c memcpy.c \
memmove.c memset.c strcat.c strchr.c \
strcmp.c strcpy.c strcspn.c strerror.c \
strlen.c strncat.c strncmp.c strncpy.c \
strpbrk.c strrchr.c strspn.c strstr.c \
strtok.c raise.c signal.c clearerr.c \
fclose.c feof.c ferror.c fflush.c \
fgetc.c fgetpos.c fgets.c fopen.c \
fprintf.c fputc.c fread.c freopen.c \
fscanf.c fseek.c fsetpos.c ftell.c \
fwrite.c gets.c perror.c printf.c puts.c \
remove.c rename.c scanf.c setbuf.c \
setvbuf.c sprintf.c sscanf.c tmpfile.c \
tmpnam.c ungetc.c vfprintf.c vprintf.c \
vsprintf.c bcopy.c bzero.c mblen.c \
mbstowcs.c wcstombs.c wctomb.c \
floatlib.c atan.c cosh.c exp.c floor.c fmod.c log.c \
log10.c pow.c sinh.c tanh.c atan2.c tan.c sincos.c errno.c fputs.c \
sqrt.c asincos.c modf.c ldexp.c frexp.c exp__E.c __isnan.c __logb.c \
log__L.c __drem.c __expm1.c xprintf.c xputfld.c xmbtowc.c xlitob.c \
xldtob.c xldunsca.c xstate.c xstoul.c xgenld.c rewind.c \
xscanf.c xgetfld.c xgetint.c xgetfloa.c xgetmem.c asctime.c clock.c \
ctime.c difftime.c gmtime.c localtim.c mktime.c strftime.c \
time.c xgettime.c xstrftim.c xttotm.c xgetzone.c xgentime.c xisdst.c \
xgetdst.c xctype.c xtoupper.c xtolower.c setjmp.c ints.c int2.c int3.c \
arit.c int32.c int33.c int34.c int35.c int36.c int37.c int38.c int39.c \
intdefault.c intrptr.c

#
# You have to use -lm and #define __USE_MISC to get to these
#
MFILES=acosh.c asinh.c atanh.c log1p.c __expm1.c version.c
CRT0FILES=crt0.c scrt0.c vcrt0.c

#
# Files for support of the -g switch...
#
GFILES=dummy.c

#
# Documentation etc.
#
OTHER_USED_FILES=Makefile Real.makefile README TODO COPYING COPYING.LIB ChangeLog read.me

#
# Matches for stuff we want to remove when clean
#
CLEAN_REMOVE_PATTERNS=*~ *.stamp *.[os] */*.[os] lib*.a cris_c_support.xtar cris_c_support

#
# If you make any additions to these, you are on your own; it won't be
# strictly ANSI-only.
#
STDHEADERS= $(includedir)/assert.h $(includedir)/ctype.h \
 $(includedir)/errno.h $(includedir)/float.h $(includedir)/limits.h \
 $(includedir)/locale.h $(includedir)/math.h \
 $(includedir)/setjmp.h $(includedir)/signal.h $(includedir)/stdarg.h \
 $(includedir)/stddef.h $(includedir)/stdio.h $(includedir)/stdlib.h \
 $(includedir)/string.h $(includedir)/time.h \
 $(includedir)/varargs.h

SFILES=$(CFILES)

SOFILES=$(SFILES:%.c=%.o)

# RFILES supplied to us; let's state an understandable error-generating
# default.
RFILES=_You_should_use_Makefile_and_not_Real.makefile_since_the_former_will_generate_RFILES_through_the_shell_and_call_Makefile.c

# Same for HFILES
HFILES=_You_should_use_Makefile_and_not_Real.makefile_since_the_former_will_generate_RFILES_through_the_shell_and_call_Makefile.h
PHFILES=$(HFILES:%=./%)
PCFILES=$(CFILES:%=./%)

REAL_CFILES=$(PCFILES:./%=%)
REAL_HFILES=$(PHFILES:./%=%)

ROFILES=dummy.o
ROFILES=$(RFILES:%.c=%.o)
MOFILES=$(MFILES:%.c=%.o)
GOFILES=$(GFILES:%.c=%.o)

all: install

#
# Housekeeping-functions for the first part of the makefile
#

# Avoid duplicating these files in *both* makefiles
echo-cfiles:
	@echo $(CFILES)

# Avoid duplicating these files in *both* makefiles
echo-all-cfiles:
	@echo $(CFILES) $(MFILES) $(CRT0FILES) $(GFILES)

install: install.stamp

install.stamp: headers $(installdir)/libc.a $(installdir)/libsc.a \
 $(installdir)/crt0.o  $(installdir)/scrt0.o  $(installdir)/vcrt0.o \
 $(installdir)/mcrt0.o  $(installdir)/gcrt0.o \
 $(installdir)/libm.a  $(installdir)/libg.a $(installdir)/libc_p.a
	touch install.stamp

uninstall:
	rm -rf $(STDHEADERS)
	rm -rf  $(installdir)/libc.a $(installdir)/libsc.a \
           $(installdir)/crt0.o  $(installdir)/scrt0.o  $(installdir)/vcrt0.o \
           $(installdir)/mcrt0.o  $(installdir)/gcrt0.o \
           $(installdir)/libm.a $(installdir)/libg.a  $(installdir)/libc_p.a
	rm -rf install.stamp

$(installdir)/libc.a: libc.a
	$(XC)cp -p $? $@

$(installdir)/libsc.a: libsc.a
	$(XC)cp -p $? $@

$(installdir)/libm.a: libm.a
	$(XC)cp -p $? $@

$(installdir)/libg.a: libg.a
	$(XC)cp -p $? $@

#
# No difference (yet) between libc.a and libc_p.a
#
$(installdir)/libc_p.a:
	ln -s $(installdir)/libc.a $@

$(installdir)/crt0.o: crt0.o
	$(XC)cp -p $? $@

$(installdir)/vcrt0.o: vcrt0.o
	$(XC)cp -p $? $@

$(installdir)/scrt0.o: scrt0.o
	$(XC)cp -p $? $@
#
# No difference between mcrt0.o and gcrt0.o and crt0.o
#
$(installdir)/mcrt0.o:
	ln -s $(installdir)/crt0.o $@

$(installdir)/gcrt0.o:
	ln -s $(installdir)/crt0.o $@

almostall: libc.a libsc.a libm.a libg.a crt0.o vcrt0.o scrt0.o

libc.a: libc.a($(ROFILES))
	$(RANLIB) $@

libc.a(%.o): %.o
	$(AR) $(ARFLAGS) libc.a $%

libsc.a: libsc.a($(SOFILES))
	$(RANLIB) $@

libsc.a(%.o): %.o
	$(AR) $(ARFLAGS) libsc.a $%

libm.a: libm.a($(MOFILES))
	$(RANLIB) $@

libm.a(%.o): %.o
	$(AR) $(ARFLAGS) libm.a $%

libg.a: libg.a($(GOFILES))
	$(RANLIB) $@

libg.a(%.o): %.o
	$(AR) $(ARFLAGS) libg.a $%

#
# Get hold of .c files we dont use.
#
# Use Makefile as a "stopper" for the "or"-list created in
# NO_MENTION_FILES_CASES below.
#
NO_MENTION_FILES_CASES=$(CFILES:%=% |) $(MFILES:%=% |) $(CRT0FILES:%=% |) $(GFILES:%=% |) $(OTHER_USED_FILES:%=% |) $(CLEAN_REMOVE_PATTERNS:%=% |) $(HFILES:%=% |)
c-check:
	@echo "  The" following files are not included in the distribution
	@echo "  and" are not used by any target:
	@for f in * */*; do case `basename $$f` in $(NO_MENTION_FILES_CASES) Makefile );; *) if [ ! -d $$f ]; then echo $$f; fi; esac; done

# Have a meta character (;) so sh will be used.
check-env get-env:
	@set ;

distclean clean:
	-rm -f $(CLEAN_REMOVE_PATTERNS)

#
# Make a distribution tar
#
dist distrib: cris_c_support.xtar

#
# Call it cris_c_support.xtar, so it wont be wiped away when included
# in gcc-cris distribution, NOT .tar, because Makefile for gcc removes .tar on
# occasions. 
#
cris_c_support.xtar:
	-rm -rf cris_c_support cris_c_support.xtar
	mkdir cris_c_support
	for F in `echo $(VPATH) | tr ':.' '  '`; do mkdir cris_c_support/$$F; done
	for F in $(REAL_HFILES) $(REAL_CFILES) $(OTHER_USED_FILES); do \
              cp -p $$F cris_c_support/$$F; done
	cd cris_c_support; tar cf ../cris_c_support.xtar .
	rm -rf cris_c_support

headers: headers.stamp

headers.stamp: $(STDHEADERS)
	touch headers.stamp

$(includedir)/assert.h: assert.h
	$(XC)cp -p $? $@

$(includedir)/ctype.h: ctype.h
	$(XC)cp -p $? $@

$(includedir)/errno.h: errno/errno.h
	$(XC)cp -p $? $@

$(includedir)/float.h: float.h
	$(XC)cp -p $? $@

$(includedir)/limits.h: limits.h
	$(XC)cp -p $? $@

$(includedir)/locale.h: locale.h
	$(XC)cp -p $? $@

$(includedir)/math.h: math/math.h
	$(XC)cp -p $? $@

$(includedir)/setjmp.h: setjmp/setjmp.h
	$(XC)cp -p $? $@

$(includedir)/signal.h: signal/signal.h
	$(XC)cp -p $? $@

$(includedir)/stdarg.h: stdarg.h
	$(XC)cp -p $? $@

$(includedir)/stddef.h: stddef.h
	$(XC)cp -p $? $@

$(includedir)/stdio.h: stdio/stdio.h
	$(XC)cp -p $? $@

$(includedir)/stdlib.h: stdlib/stdlib.h
	$(XC)cp -p $? $@

$(includedir)/string.h: string/string.h
	$(XC)cp -p $? $@

$(includedir)/time.h: time/time.h
	$(XC)cp -p $? $@

$(includedir)/varargs.h: varargs.h
	$(XC)cp -p $? $@

$(includedir)/sys/simcodes.h: ./simcodes.h
	$(XC)cp -p $? $@

abort.o : abort.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  $(includedir)/signal.h 

atexit.o : atexit.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h 

atof.o : atof.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  ./support.h 

atoi.o : atoi.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  ./support.h 

atol.o : atol.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h 

bsearch.o : bsearch.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h 

calloc.o : calloc.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  $(includedir)/string.h 

div.o : div.c $(includedir)/stdlib.h $(includedir)/stddef.h \
  $(includedir)/errno.h 

free.o : free.c ./xalloc.h $(includedir)/stddef.h \
  $(includedir)/stdlib.h $(includedir)/errno.h \
  ./yvals.h 

getenv.o : getenv.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  $(includedir)/string.h ./yfuns.h ./simcodes.h 

ldiv.o : ldiv.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h 

malloc.o : malloc.c ./xalloc.h $(includedir)/stddef.h \
  $(includedir)/stdlib.h $(includedir)/errno.h \
  ./yvals.h ./yfuns.h 

qsort.o : qsort.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  $(includedir)/string.h 

rand.o : rand.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h 

realloc.o : realloc.c $(includedir)/string.h \
  $(includedir)/stddef.h ./xalloc.h $(includedir)/stdlib.h \
  $(includedir)/errno.h ./yvals.h 

srand.o : srand.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h 

strtol.o : strtol.c $(includedir)/ctype.h \
  $(includedir)/errno.h $(includedir)/limits.h \
  $(includedir)/stdlib.h $(includedir)/stddef.h 

strtoul.o : strtoul.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h 

system.o : system.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  ./simcodes.h 

memchr.o : memchr.c $(includedir)/string.h \
  $(includedir)/stddef.h 

memcmp.o : memcmp.c $(includedir)/stddef.h 

memcpy.o : memcpy.c $(includedir)/stddef.h 

memmove.o : memmove.c $(includedir)/stddef.h 

memset.o : memset.c $(includedir)/stddef.h 

strcat.o : strcat.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strchr.o : strchr.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strcmp.o : strcmp.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strcpy.o : strcpy.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strcspn.o : strcspn.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strerror.o : strerror.c $(includedir)/errno.h \
  $(includedir)/string.h $(includedir)/stddef.h \
  ./simcodes.h 

strlen.o : strlen.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strncat.o : strncat.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strncmp.o : strncmp.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strncpy.o : strncpy.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strpbrk.o : strpbrk.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strrchr.o : strrchr.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strspn.o : strspn.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strstr.o : strstr.c $(includedir)/string.h \
  $(includedir)/stddef.h 

strtok.o : strtok.c $(includedir)/string.h \
  $(includedir)/stddef.h 

raise.o : raise.c $(includedir)/signal.h \
  $(includedir)/stdio.h $(includedir)/stddef.h \
  $(includedir)/stdarg.h $(includedir)/varargs.h \
  $(includedir)/stdlib.h $(includedir)/errno.h 

signal.o : signal.c $(includedir)/signal.h 

clearerr.o : clearerr.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/errno.h \
  ./simcodes.h 

fclose.o : fclose.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

feof.o : feof.c $(includedir)/stdio.h $(includedir)/stddef.h \
  $(includedir)/stdarg.h $(includedir)/varargs.h \
  ./simcodes.h 

ferror.o : ferror.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h 

fflush.o : fflush.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

fgetc.o : fgetc.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

fgetpos.o : fgetpos.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

fgets.o : fgets.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h 

fopen.o : fopen.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h 

fprintf.o : fprintf.c ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h \
  $(includedir)/stddef.h 

fputc.o : fputc.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

fread.o : fread.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

freopen.o : freopen.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

fscanf.o : fscanf.c ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h \
  $(includedir)/stddef.h 

fseek.o : fseek.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

fsetpos.o : fsetpos.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

ftell.o : ftell.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

fwrite.o : fwrite.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

gets.o : gets.c $(includedir)/stdio.h $(includedir)/stddef.h \
  $(includedir)/stdarg.h $(includedir)/varargs.h 

perror.o : perror.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/errno.h \
  $(includedir)/string.h 

printf.o : printf.c ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h \
  $(includedir)/stddef.h 

puts.o : puts.c $(includedir)/stdio.h $(includedir)/stddef.h \
  $(includedir)/stdarg.h $(includedir)/varargs.h 

remove.o : remove.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

rename.o : rename.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/errno.h \
  ./simcodes.h 

scanf.o : scanf.c ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h \
  $(includedir)/stddef.h 

setbuf.o : setbuf.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h 

setvbuf.o : setvbuf.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h 

sprintf.o : sprintf.c $(includedir)/string.h \
  $(includedir)/stddef.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h 

sscanf.o : sscanf.c ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h \
  $(includedir)/stddef.h 

tmpfile.o : tmpfile.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

tmpnam.o : tmpnam.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h $(includedir)/errno.h 

ungetc.o : ungetc.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h 

vfprintf.o : vfprintf.c ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h \
  $(includedir)/stddef.h 

vprintf.o : vprintf.c ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h \
  $(includedir)/stddef.h 

vsprintf.o : vsprintf.c $(includedir)/string.h \
  $(includedir)/stddef.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h 

bcopy.o : bcopy.c 

bzero.o : bzero.c 

mblen.o : mblen.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  ./xstdio.h $(includedir)/stdarg.h $(includedir)/varargs.h \
  $(includedir)/stdio.h 

mbstowcs.o : mbstowcs.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  ./xstdio.h $(includedir)/stdarg.h $(includedir)/varargs.h \
  $(includedir)/stdio.h 

wcstombs.o : wcstombs.c $(includedir)/limits.h \
  $(includedir)/string.h $(includedir)/stddef.h \
  $(includedir)/stdlib.h $(includedir)/errno.h \
  ./xstdio.h $(includedir)/stdarg.h $(includedir)/varargs.h \
  $(includedir)/stdio.h 

wctomb.o : wctomb.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h 

atan.o : atan.c 

cosh.o : cosh.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

exp.o : exp.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

floor.o : floor.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

fmod.o : fmod.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

log.o : log.c $(includedir)/errno.h \
  mathimpl.h $(includedir)/math.h \
  $(includedir)/float.h 

log10.o : log10.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

pow.o : pow.c $(includedir)/errno.h \
  mathimpl.h $(includedir)/math.h \
  $(includedir)/float.h 

sinh.o : sinh.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

tanh.o : tanh.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

atan2.o : atan2.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

tan.o : tan.c trig.h mathimpl.h \
  $(includedir)/math.h $(includedir)/errno.h \
  $(includedir)/float.h 

sincos.o : sincos.c trig.h mathimpl.h \
  $(includedir)/math.h $(includedir)/errno.h \
  $(includedir)/float.h 

errno.o : errno.c 

fputs.o : fputs.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h 

sqrt.o : sqrt.c $(includedir)/errno.h $(includedir)/math.h \
  $(includedir)/float.h 

asincos.o : asincos.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

modf.o : modf.c $(includedir)/math.h $(includedir)/errno.h \
  $(includedir)/float.h 

ldexp.o : ldexp.c $(includedir)/math.h $(includedir)/errno.h \
  $(includedir)/float.h ./ieee754.h 

frexp.o : frexp.c $(includedir)/errno.h \
  $(includedir)/math.h $(includedir)/float.h 

exp__E.o : exp__E.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

__isnan.o : __isnan.c $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h \
  ./ieee754.h 

__logb.o : __logb.c $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h \
  ./ieee754.h 

log__L.o : log__L.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

__drem.o : __drem.c $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h \
  ./ieee754.h 

__expm1.o : __expm1.c mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

xprintf.o : xprintf.c $(includedir)/ctype.h \
  $(includedir)/stdlib.h $(includedir)/stddef.h \
  $(includedir)/errno.h $(includedir)/string.h \
  ./xstdio.h $(includedir)/stdarg.h $(includedir)/varargs.h \
  $(includedir)/stdio.h 

xputfld.o : xputfld.c $(includedir)/string.h \
  $(includedir)/stddef.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h 

xmbtowc.o : xmbtowc.c $(includedir)/limits.h \
  $(includedir)/stdlib.h $(includedir)/stddef.h \
  $(includedir)/errno.h ./xstate.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h 

xlitob.o : xlitob.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  $(includedir)/string.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h 

xldtob.o : xldtob.c $(includedir)/float.h \
  $(includedir)/stdlib.h $(includedir)/stddef.h \
  $(includedir)/errno.h $(includedir)/string.h \
  ./xstdio.h $(includedir)/stdarg.h $(includedir)/varargs.h \
  $(includedir)/stdio.h 

xldunsca.o : xldunsca.c $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h \
  ./xstdio.h $(includedir)/stdarg.h $(includedir)/varargs.h \
  $(includedir)/stdio.h $(includedir)/stddef.h 

xstate.o : xstate.c $(includedir)/limits.h \
  ./xstate.h 

xstoul.o : xstoul.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  $(includedir)/ctype.h $(includedir)/limits.h \
  $(includedir)/string.h 

xgenld.o : xgenld.c $(includedir)/locale.h \
  $(includedir)/string.h $(includedir)/stddef.h \
  ./xstdio.h $(includedir)/stdarg.h $(includedir)/varargs.h \
  $(includedir)/stdio.h 

rewind.o : rewind.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h 

xscanf.o : xscanf.c $(includedir)/ctype.h \
  $(includedir)/limits.h $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  $(includedir)/string.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h 

xgetfld.o : xgetfld.c $(includedir)/ctype.h \
  $(includedir)/limits.h $(includedir)/string.h \
  $(includedir)/stddef.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h 

xgetint.o : xgetint.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  $(includedir)/string.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h 

xgetfloa.o : xgetfloa.c $(includedir)/ctype.h \
  $(includedir)/locale.h $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  $(includedir)/string.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h 

xgetmem.o : xgetmem.c ./xalloc.h $(includedir)/stddef.h \
  $(includedir)/stdlib.h $(includedir)/errno.h \
  ./yvals.h ./simcodes.h 

asctime.o : asctime.c ./xtime.h $(includedir)/time.h \
  $(includedir)/stddef.h ./xtinfo.h 

clock.o : clock.c $(includedir)/time.h $(includedir)/stddef.h 

ctime.o : ctime.c $(includedir)/time.h $(includedir)/stddef.h 

difftime.o : difftime.c $(includedir)/time.h \
  $(includedir)/stddef.h 

gmtime.o : gmtime.c ./xtime.h $(includedir)/time.h \
  $(includedir)/stddef.h ./xtinfo.h 

localtim.o : localtim.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  ./xtime.h $(includedir)/time.h ./xtinfo.h 

mktime.o : mktime.c $(includedir)/limits.h \
  ./xtime.h $(includedir)/time.h $(includedir)/stddef.h \
  ./xtinfo.h 

strftime.o : strftime.c ./xtime.h $(includedir)/time.h \
  $(includedir)/stddef.h ./xtinfo.h 

time.o : time.c $(includedir)/time.h $(includedir)/stddef.h \
  ./simcodes.h 

xgettime.o : xgettime.c $(includedir)/string.h \
  $(includedir)/stddef.h ./xtime.h $(includedir)/time.h \
  ./xtinfo.h 

xstrftim.o : xstrftim.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  $(includedir)/string.h ./xtime.h $(includedir)/time.h \
  ./xtinfo.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h 

xttotm.o : xttotm.c ./xtime.h $(includedir)/time.h \
  $(includedir)/stddef.h ./xtinfo.h 

xgetzone.o : xgetzone.c $(includedir)/ctype.h \
  $(includedir)/stdlib.h $(includedir)/stddef.h \
  $(includedir)/errno.h $(includedir)/string.h \
  ./xtime.h $(includedir)/time.h ./xtinfo.h 

xgentime.o : xgentime.c ./xtime.h $(includedir)/time.h \
  $(includedir)/stddef.h ./xtinfo.h 

xisdst.o : xisdst.c $(includedir)/stdlib.h \
  $(includedir)/stddef.h $(includedir)/errno.h \
  ./xtime.h $(includedir)/time.h ./xtinfo.h 

xgetdst.o : xgetdst.c $(includedir)/ctype.h \
  $(includedir)/stdlib.h $(includedir)/stddef.h \
  $(includedir)/errno.h $(includedir)/string.h \
  ./xtime.h $(includedir)/time.h ./xtinfo.h 

xctype.o : xctype.c $(includedir)/ctype.h \
  $(includedir)/limits.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h \
  $(includedir)/stddef.h 

xtolower.o : xtolower.c $(includedir)/ctype.h \
  $(includedir)/limits.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h \
  $(includedir)/stddef.h 

xtoupper.o : xtoupper.c $(includedir)/ctype.h \
  $(includedir)/limits.h ./xstdio.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h $(includedir)/stdio.h \
  $(includedir)/stddef.h 

strtod.o : strtod.c $(includedir)/errno.h \
  $(includedir)/float.h $(includedir)/ctype.h \
  $(includedir)/stdlib.h $(includedir)/stddef.h \
  $(includedir)/string.h $(includedir)/math.h \
  $(includedir)/limits.h 

floatlib.o : floatlib.c $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

setjmp.o : setjmp.c $(includedir)/setjmp.h

ints.o : ints.c

int2.o : int2.c

int3.o : int3.c

int32.o : int32.c

int33.o : int33.c

int34.o : int34.c

int35.o : int35.c

int36.o : int36.c

int37.o : int37.c

int38.o : int38.c

int39.o : int39.c

intdefault.o: intdefault.c

intrptr.o : intrptr.c

#
# This is the only file that we ever should use the -mul switch for!
#
arit.o : arit.c
	$(COMPILE.c) -mul $(OUTPUT_OPTION) $<
#
# For those non-ansii math functions that really should be ansii...
#
acosh.o : acosh.c math/mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

asinh.o : asinh.c math/mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

atanh.o : atanh.c math/mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

log1p.o : log1p.c $(includedir)/errno.h \
  math/mathimpl.h $(includedir)/math.h $(includedir)/float.h 

__expm1.o : __expm1.c math/mathimpl.h $(includedir)/math.h \
  $(includedir)/errno.h $(includedir)/float.h 

#
# We dont have a special library for the -g switch, so lets fake one.
#
dummy.o: dummy.c

#
# The different crt0 flavors.
#
vcrt0.o : vcrt0.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h  

scrt0.o : scrt0.c $(includedir)/stdio.h \
  $(includedir)/stddef.h $(includedir)/stdarg.h \
  $(includedir)/varargs.h ./simcodes.h 

crt0.o : crt0.c $(includedir)/stdio.h $(includedir)/stddef.h \
  $(includedir)/stdarg.h $(includedir)/varargs.h \
  ./simcodes.h 
