/* cris.h -- Header file for the CGA-RISC.
   Copyright (C) 1989 Free Software Foundation, Inc.

This file is part of GAS, the GNU Assembler.

GAS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GAS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GAS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __TC_CRIS_H__
#define __TC_CRIS_H__

/* 920312 Initial version created by copying sparc.h in GAS v 1.38.1 */
/* 960703 HP     Updated to binutils-2.6, added ifndef-construct */


/* Changed 920331 by MA */
/* 920812  MA  Changed value of RELOC_BDISP8 so relocation types in */
/*               output files can be stored in two bits.            */

/* Don't know if we should use these, or use the generic ones.  Try:
   use the generic ones, and #define our specials. */
#define CRIS_RELOC_8 BFD_RELOC_8
#define CRIS_RELOC_16 BFD_RELOC_16
#define CRIS_RELOC_32 BFD_RELOC_32
#define CRIS_RELOC_NONE BFD_RELOC_NONE

/* Define as obscure generic variants */
#define CRIS_RELOC_DISP8      BFD_RELOC_8_PLTOFF
#define CRIS_RELOC_BDISP8     BFD_RELOC_32_GOT_PCREL
#define CRIS_RELOC_UNSIGNED_5 BFD_RELOC_16_GOT_PCREL
#define CRIS_RELOC_SIGNED_6   BFD_RELOC_8_GOT_PCREL
#define CRIS_RELOC_UNSIGNED_6 BFD_RELOC_32_GOTOFF
#define CRIS_RELOC_UNSIGNED_4 BFD_RELOC_8_GOTOFF

/* 920331 MA renamed reloc_info_sparc to reloc_info_cris */

struct reloc_info_cris
{
    unsigned long int r_address;
/*
 * Using bit fields here is a bad idea because the order is not portable. :-(
 */
    unsigned int     r_index   : 24;
    unsigned int     r_extern  : 1;
    unsigned int     unused    : 2;
    enum bfd_reloc_code_real  r_type    : 5;
    long int         r_addend;
};

#define relocation_info reloc_info_cris

#define TARGET_FORMAT "a.out-cris"
#define TARGET_ARCH bfd_arch_cris

extern const struct relax_type md_relax_table[];
#define TC_GENERIC_RELAX_TABLE md_relax_table

#define md_operand(x)

/* Do this, or we will never know what hit us when the
   broken-word-fixes break.  Do _not_ use WARN_SIGNED_OVERFLOW_WORD,
   it is broken ("warns" about most stuff) */
#define ERR_ADJUSTED_SIGNED_OVERFLOW_WORD

/* Fix for broken alignment-assumption in read.c:s_lcomm */
#define NO_IMPLICIT_SECTION_ALIGNMENT 1

#endif /* __TC_CRIS_H__ */
