/*
 * Decompiled with CFR 0.152.
 */
package com.novell.imanage.ndps.plugins;

import com.novell.emframe.dev.PluginContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.service.ndps.Oid;
import com.novell.service.ndps.PrinterAgent;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;

public class AxisIPPGatewayTemplate
extends Task {
    String printerURL;

    public boolean execute(TaskContext taskContext, Properties properties) {
        I18NServletRequest i18NServletRequest = taskContext.getHttpServletRequest();
        String string = i18NServletRequest.getParameter("nextState");
        if (string.equalsIgnoreCase("initialState")) {
            return true;
        }
        if (string.equalsIgnoreCase("ConfigureGateway")) {
            try {
                this.printerURL = i18NServletRequest.getParameter("CreatePrinterURL");
                return this.populateGatewayLoadString(taskContext, properties);
            }
            catch (Exception exception) {
                properties.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"AxisIPPResources", (String)"Axis.GatewayConfigurationFailure", (PluginContext)taskContext));
                properties.put("GeneralMsg.MsgBody", exception.toString());
                properties.put("GeneralMsg.Mode", "error");
                return false;
            }
        }
        return false;
    }

    private boolean populateGatewayLoadString(TaskContext taskContext, Properties properties) {
        try {
            Hashtable hashtable = taskContext.getSessionCache();
            PrinterAgent printerAgent = (PrinterAgent)hashtable.get("NDPS.newPrinterAgent");
            BasicAttributes basicAttributes = new BasicAttributes();
            basicAttributes.put(Oid.NDPS_ATT_PDS_EXEC_AND_PARAMS.getString(), "NDPSGW IPP URL=" + this.printerURL);
            printerAgent.modifyAttrs(2, (Attributes)basicAttributes);
            this.taskCompleteFlag = true;
            return true;
        }
        catch (Exception exception) {
            properties.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString((String)"AxisIPPResources", (String)"Axis.GatewayConfigurationFailure", (PluginContext)taskContext));
            properties.put("GeneralMsg.MsgBody", exception.toString());
            properties.put("GeneralMsg.Mode", "error");
            return false;
        }
    }
}

