/** @file
 *
 * Declaration of IAxPropertySet.
 *
 * FILE NAME  : $Workfile: IAxPropertySet.h $
 * 
 * 
 * INTERFACES    : IAxPropertySet
 * 
 * ---------------------------------------------------------------------------
 *
 * HISTORY
 * 
 * VER   DATE     TIME  NAME
 * ---   ----     ----  ----
 *
 * $Log: /components/external/DirectShow/RTPSourceFilter/IAxPropertySet.h $ (Source Safe project path)
 * 
 * 1     5/22/03 11:50a Enriqueg
 * Fisrt Version
 * 
 * 3     03-02-10 13:01 Victor
 * 
 * 2     02-04-30 13:06 Victor
 * Modified SourceSafe path.
 * 
 * 1     02-02-28 9:46 Victor
 * First version.
 * 
 * ---------------------------------------------------------------------------
 * 
 * <p><b>
 * (C) Copyright 2002, Axis Communications AB, LUND, SWEDEN
 * </b>
 * 
**/
#if !defined(AFX_IAXPROPERTYSET_H__045E2E39_B68B_47E8_BFE5_EB8275FEABEC__INCLUDED_)
#define AFX_IAXPROPERTYSET_H__045E2E39_B68B_47E8_BFE5_EB8275FEABEC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef __cplusplus
extern "C" {
#endif

/****************** INCLUDE FILES SECTION ***********************************/

/******************** DEFINITION SECTION ************************************/

// IID is {DE69F62B-FCEC-4902-BCDD-1E6E44331275}
// Use the following in a cpp file
//// {DE69F62B-FCEC-4902-BCDD-1E6E44331275}
// const IID IID_IAxPropertySet = 
//{ 0xde69f62b, 0xfcec, 0x4902, { 0xbc, 0xdd, 0x1e, 0x6e, 0x44, 0x33, 0x12, 0x75 } };
EXTERN_C const IID IID_IAxPropertySet;

/****************** INTERFACE DEFINITION SECTION ****************************/

DECLARE_INTERFACE_(IAxPropertySet, IUnknown)
{
  /**
   * Get a property.
   *
   * @param thePropName name of the property to get.
   * @param thePropValue value of the property returned.
   *
  **/
  STDMETHOD(GetProperty)
      ( THIS_
        /* [in] */ BSTR thePropName,
        /* [out, retval] */ VARIANT* thePropValue
      ) PURE;
 
  /**
   * Set a property.
   *
   * @param thePropName name of the property to set.
   * @param thePropValue value of the property to set.
   *
  **/
  STDMETHOD(SetProperty)
      ( THIS_
        /* [in] */ BSTR thePropName,
        /* [in] */ VARIANT thePropValue
      ) PURE;

};

#ifdef __cplusplus
}
#endif

_COM_SMARTPTR_TYPEDEF(IAxPropertySet, IID_IAxPropertySet);

#endif // !defined(AFX_IAXPROPERTYSET_H__045E2E39_B68B_47E8_BFE5_EB8275FEABEC__INCLUDED_)

/****************** END OF FILE $Workfile: IAxPropertySet.h $ ***************/