/** @file IAxMediaRecorder
 *
 * ---------------------------------------------------------------------------
 * 
 * <p><b>
 * (C) Copyright 2004, Axis Communications AB, LUND, SWEDEN
 * </b>
 * 
**/

#if !defined(AFX_IAXMEDIARECORDER_H__B87C4B31_BCDF_4959_9437_06E7EAEB3504__INCLUDED_)
#define AFX_IAXMEDIARECORDER_H__B87C4B31_BCDF_4959_9437_06E7EAEB3504__INCLUDED_


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef __cplusplus
extern "C" {
#endif

/****************** INCLUDE FILES SECTION ***********************************/

/******************** DEFINITION SECTION ************************************/


// IID is {E2B8C062-0079-451a-AAC5-317FF1979F16}
// Use the following in a cpp file
// {E2B8C062-0079-451a-AAC5-317FF1979F16}
// const IID IID_IAxMediaRecorder = 
// { 0xe2b8c062, 0x79, 0x451a, { 0xaa, 0xc5, 0x31, 0x7f, 0xf1, 0x97, 0x9f, 0x16 } };

typedef enum {
    RECM_VIDEO                        =  1,
    RECM_AUDIO                        =  2,
    RECM_VIDEO_AUDIO                  =  3
} RecMode;

EXTERN_C const IID IID_IAxMediaRecorder;

/****************** INTERFACE DEFINITION SECTION ****************************/

DECLARE_INTERFACE_(IAxMediaRecorder, IUnknown)
{
/**
* Set the output file.
*
* @param theFileName name of the property to get.
* @param thePropValue value of the property returned.
*
  **/
  STDMETHOD(BeginRecording)
    ( THIS_
			BSTR theFileName, RecMode theRecMode
    ) PURE;
  
  
  STDMETHOD(EndRecording)
    ( THIS_
    ) PURE;
  
  STDMETHOD(SetOutputFilename)
    ( THIS_
    /* [in] */ BSTR theFileName
    ) PURE;
  
  STDMETHOD(SetOutputFileformat)
    ( THIS_
    /* [in] */ BSTR theFileformat
    ) PURE;

   STDMETHOD(IsRecordable)
    ( THIS_
    /* [out] */ bool* canRecord
    ) PURE;
 
    STDMETHOD(SetRecMode)
    ( THIS_
    /* [in] */ RecMode theRecMode
    ) PURE;
};

#ifdef __cplusplus
}
#endif

_COM_SMARTPTR_TYPEDEF(IAxMediaRecorder, IID_IAxMediaRecorder);

#endif // !defined(AFX_IAXMEDIARECORDER_H__B87C4B31_BCDF_4959_9437_06E7EAEB3504__INCLUDED_)
/****************** END OF FILE $Workfile: IAxMediaRecorder.h $ ***************/