/** @file IAxEventNotifier.h
 *
 * <p><b>
 * (C) Copyright 2003, Axis Communications AB, LUND, SWEDEN
 * </b>
 * 
**/
#if !defined(AFX_IAXEVENTNOTIFIER_H__045E2E39_B68B_47E8_BFE5_EB8275FEABEC__INCLUDED_)
#define AFX_IAXEVENTNOTIFIER_H__045E2E39_B68B_47E8_BFE5_EB8275FEABEC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef __cplusplus
extern "C" {
#endif

/****************** INCLUDE FILES SECTION ***********************************/

/******************** DEFINITION SECTION ************************************/

// IID is {26E556C1-E0E2-4cd2-B897-230A292F8CB1}
// Use the following in a cpp file
//// {26E556C1-E0E2-4cd2-B897-230A292F8CB1}
//const IID IID_IAxEventListener = 
//{ 0x26e556c1, 0xe0e2, 0x4cd2, { 0xb8, 0x97, 0x23, 0xa, 0x29, 0x2f, 0x8c, 0xb1 } };
EXTERN_C const IID IID_IAxEventListener;

// IID is {C365F894-B856-4c80-9D90-3CEC6E742F33}
// Use the following in a cpp file
//// {C365F894-B856-4c80-9D90-3CEC6E742F33}
//const IID IID_IAxEventNotifier = 
//{ 0xc365f894, 0xb856, 0x4c80, { 0x9d, 0x90, 0x3c, 0xec, 0x6e, 0x74, 0x2f, 0x33 } };
EXTERN_C const IID IID_IAxEventNotifier;

/****************** INTERFACE DEFINITION SECTION ****************************/

DECLARE_INTERFACE_(IAxEventListener, IUnknown)
{
  /**
   * Notify a new event.
   *
   * @param theEventId id of the event.
   * @param theEventInfo additional info on the event.
   *
  **/
  STDMETHOD(OnNewEvent)
    ( THIS_
      /* [in] */ long theEventId,
      /* [in] */ BSTR theEventInfo
    ) PURE;
};

DECLARE_INTERFACE_(IAxEventNotifier, IUnknown)
{
  /**
   * Register an event listener. Only one listener supported.
   *
   * @param theListener the interface to the listener.
   *                    Send NULL to clear the registration.
   *
  **/
  STDMETHOD(RegisterListener)
    ( THIS_
      /* [in] */ IAxEventListener* theListener
    ) PURE;
};

#ifdef __cplusplus
}
#endif

_COM_SMARTPTR_TYPEDEF(IAxEventListener, IID_IAxEventListener);
_COM_SMARTPTR_TYPEDEF(IAxEventNotifier, IID_IAxEventNotifier);

#endif // !defined(AFX_IAXEVENTNOTIFIER_H__045E2E39_B68B_47E8_BFE5_EB8275FEABEC__INCLUDED_)

/****************** END OF FILE $Workfile: IAxEventNotifier.h $ ***************/