/** \AMPFileSource.h
*
* Class for reading media from standard AMP file
*
* (C) Copyright 2010, Axis Communications AB, LUND, SWEDEN
****************************************************************************/

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/****************** INCLUDE FILES SECTION ***********************************/

#include <tchar.h>
#include <Dshow.h>

/****************** DEFINITION SECTION **************************************/

class AMPFileSource
{
public:
  AMPFileSource();
  ~AMPFileSource();

  /// Loads a file created with AXIS Media Parser.
  HRESULT Load(_TCHAR* theFile);

  /// Retrieves media type information for the streams contained in the loaded file.
  HRESULT GetStreamInfo(AM_MEDIA_TYPE** theMediaType, DWORD theIndex);

  /// Get the stream index, size and other properties of the next samples in the file stream.
  HRESULT GetNextSampleProperties(DWORD* theStreamIndex, DWORD* theSampleSize,
                                  REFERENCE_TIME* theStartTime, REFERENCE_TIME* theStopTime,
                                  BOOL* isSyncPoint);

  /// Copies the sample data of the next sample to the provided buffer.
  /// Call the GetNextSampleProperties before calling this method.
  HRESULT FillBuffer(BYTE* theBuffer, DWORD theBufferLength);

  /// Skips the next sample data.
  /// Call the GetNextSampleProperties before calling this method.
  HRESULT SkipBuffer();

private:

  HRESULT Close();

  HANDLE myFileHandle;
  DWORD myNumberOfStreams;
  AM_MEDIA_TYPE** myStreamMediaTypes;

  bool isLoaded;
  
  int myVideoStreamIndex;
  int myAudioStreamIndex;

  DWORD myNextSampleSize;

};