/** \AxMP4Dec.h
* Custom interface for IAxMP4Dec
*
* (C) Copyright 2006, Axis Communications AB, LUND, SWEDEN
****************************************************************************/

#ifndef _AXMP4DEC_INTERFACE_
#define _AXMP4DEC_INTERFACE_

// Decode Mode flags
#define IAXMP4DEC_DECODE_MODE_I 0x00
#define IAXMP4DEC_DECODE_MODE_IP 0x01
#define IAXMP4DEC_DECODE_MODE_ALL 0x02

// Quality Settings flags
#define IAXMP4DEC_QUALITY_MODE_ALLOW_FRAME_DROPPING 0x100

///////////////////////////////////////////////////////////////////////////////
// Parameter Info
// struct to hold the DMO's Parameters
typedef struct _AxMP4DecParams
{
	DWORD DeinterlaceFlags;
	DWORD DecodeMode;
	DWORD Deblocking;
	DWORD QSettings;
  BOOL  RGBMirrorSetting;
} AxMP4DecParams, *LPAxMP4DecParams;
typedef const AxMP4DecParams *LPCAxMP4DecParams;

#ifndef AX_MEDIA_CB
#define AX_MEDIA_CB
typedef enum {
  CB_NULL                  =  0,
  CB_MEDIA_RGB24           =  1,      
  CB_MEDIA_YV12            =  2,
  CB_MEDIA_YUY2            =  3,
  CB_MEDIA_RGB32           =  4,
  CB_MEDIA_Y               =  5,
} CBMedia;

/// Interface for callbacks
DECLARE_INTERFACE(IAxMediaCB)
{

  STDMETHOD(BufferCB)
    ( 
    LONGLONG  theStartTime,
    BYTE * theDstBuffer, 
    long  theSize
    ) PURE;
};

#endif

#ifdef __cplusplus
extern "C" {
#endif	/* C++ */

	/* Forward Declarations */ 
#ifdef __cplusplus
	typedef class CAxMP4Dec CAxMP4Dec;
#else
	typedef struct CAxMP4Dec CAxMP4Dec;
#endif /* __cplusplus */

#ifdef __cplusplus
	typedef class CAxMP4DecProp CAxMP4DecProp;
#else
	typedef struct CAxMP4DecProp CAxMP4DecProp;
#endif /* __cplusplus */

	interface IAxMP4Dec;
#ifndef __cplusplus 
	typedef interface IAxMP4Dec IAxMP4Dec;
#endif	/* C++ */


#undef  INTERFACE
#define INTERFACE  IAxMP4Dec
  /// Interface for the AxMP4Dec
	DECLARE_INTERFACE_(IAxMP4Dec, IUnknown)
	{
		// All Parameters (props)
		STDMETHOD(SetAllParameters)     (THIS_ LPCAxMP4DecParams pcAxMP4DecParams) PURE;

		STDMETHOD(GetAllParameters)     (THIS_ LPAxMP4DecParams pAxMP4DecParams) PURE;

		// De-interlace
		STDMETHOD(GetDeinterlaceFlags) (THIS_ DWORD  * theDeinterlaceFlags) PURE;

		STDMETHOD(SetDeinterlaceFlags) (THIS_ DWORD  theDeinterlaceFlags) PURE;

		STDMETHOD(SetDeinterlaceFlagsProps) (THIS_ DWORD  theDeinterlaceFlags) PURE; 

		// Decoder skipping mode
		STDMETHOD(GetDecodeFlags) (THIS_ DWORD  * theDecodeFlags) PURE;

		STDMETHOD(SetDecodeFlags) (THIS_ DWORD  theDecodeFlags) PURE;

		STDMETHOD(SetDecodeFlagsProps) (THIS_ DWORD  theDecodeFlags) PURE;

		// De-block
		STDMETHOD(GetDeblock)(DWORD  * theDeblockFlag) PURE;

		STDMETHOD(SetDeblock)(DWORD theDeblockFlag) PURE;

		STDMETHOD(SetDeblockProps)(DWORD theDeblockFlag) PURE;

		// Quality Settings
		STDMETHOD(GetQualitySettings)(DWORD * theQSetting) PURE;

		STDMETHOD(SetQualitySettings)(DWORD theQSetting) PURE;

		STDMETHOD(SetQualitySettingsProps)(DWORD theQSetting) PURE;

		// Extract
		STDMETHOD(GetCurrentPicture) (THIS_ BYTE * theDstBuffer, DWORD * theSize) PURE;

		STDMETHOD(GetUserData)(unsigned char * theDstBuffer, DWORD * theSize) PURE;

		// Listener
		STDMETHOD(SetCallback)(IAxMediaCB * theListener, CBMedia theMediaType) PURE;

		/// Call to mirror the frames horizontally when outputting in RGB.
		STDMETHOD(RGBMirror)(bool useMirror) PURE;

    STDMETHOD(GetRGBMirror)(bool* useMirror) PURE;

	};

	/* GUID Definition */
	DEFINE_GUID(CLSID_AXMP4DEC, 0XC32FE9F1, 0XA857, 0X48B0, 0XB7, 0XBF, 0X6, 0X5B, 0X57, 0X92, 0XF2, 0X8D);
	DEFINE_GUID(CLSID_AXMP4DECPROP, 0xfbfadba2, 0x1171, 0x4266, 0xb3, 0x66, 0x38, 0x9c, 0x16, 0x8d, 0xd3, 0x63);
	DEFINE_GUID(IID_IAxMP4Dec, 0x6ff6697e, 0x507b, 0x4753, 0x9a, 0xfb, 0x75, 0x42, 0xea, 0xc, 0xd5, 0xbb);

#define FOURCC_DX50 mmioFOURCC('D','X','5','0')   
	DEFINE_GUID(CLSID_DX50, FOURCC_DX50, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

#define FOURCC_MP4V mmioFOURCC('M','P','4','V')
  DEFINE_GUID(CLSID_MP4V, FOURCC_MP4V, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);

#define MP4_DEC_CLSID "{c32fe9f1-a857-48b0-b7bf-065b5792f28d}"
#ifdef __cplusplus
	class DECLSPEC_UUID("c32fe9f1-a857-48b0-b7bf-065b5792f28d") CAxMP4Dec;
	class DECLSPEC_UUID("fbfadba2-1171-4266-b366-389c168dd363") CAxMP4DecProp;
#endif

#ifdef __cplusplus
};	/* extern "C" */
#endif	/* C++ */

#endif // _AXMP4DEC_INTERFACE_

