/** \AxMJPGDec.h
* Custom interface for IAxMJPGDec
*
* (C) Copyright 2006, Axis Communications AB, LUND, SWEDEN
****************************************************************************/
#pragma once

/****************** INCLUDE FILES SECTION ***********************************/
#ifndef _AXMJPGDEC_INTERFACE_
#define _AXMJPGDEC_INTERFACE_

/****************** DEFINITION SECTION **************************************/
///////////////////////////////////////////////////////////////////////////////
// Parameter Info
// struct to hold the DMO's Parameters
typedef struct _AxMJPGDecParams
{

  BOOL isUsingRGBMirror;
  int currentOutputMediaTypes;

} AxMJPGDecParams, *LPAxMJPGDecParams;
typedef const AxMJPGDecParams *LPCAxMJPGDecParams;

#ifndef AX_MEDIA_CB
#define AX_MEDIA_CB
typedef enum {
  CB_NULL                  =  0,
  CB_MEDIA_RGB24           =  1,      
  CB_MEDIA_YV12            =  2,
  CB_MEDIA_YUY2            =  3,
  CB_MEDIA_RGB32           =  4,
  CB_MEDIA_Y               =  5,
} CBMedia;

/// Interface for callbacks
DECLARE_INTERFACE(IAxMediaCB)
{

  STDMETHOD(BufferCB)
    ( 
    LONGLONG  theStartTime,
    BYTE * theDstBuffer, 
    long  theSize
    ) PURE;
};

#endif

#ifdef __cplusplus
extern "C" {
#endif	/* C++ */

  /* Forward Declarations */ 
#ifdef __cplusplus
  typedef class CAxMJPGDec CAxMJPGDec;
#else
  typedef struct CAxMJPGDec CAxMJPGDec;
#endif /* __cplusplus */

#ifdef __cplusplus
  typedef class CAxMJPGDecProp CAxMJPGDecProp;
#else
  typedef struct CAxMJPGDecProp CAxMJPGDecProp;
#endif /* __cplusplus */

interface IAxMJPGDec;
#ifndef __cplusplus 
  typedef interface IAxMJPGDec IAxMJPGDec;
#endif	/* C++ */

#undef  INTERFACE
#define INTERFACE  IAxMJPGDec
  /// Interface for the AxMJPGDec
  DECLARE_INTERFACE_(IAxMJPGDec, IUnknown)
  {
    /// Sets all AXMJPGDec parameters
    STDMETHOD(SetAllParameters)     (THIS_ LPCAxMJPGDecParams pcAxMJPGDecParams) PURE;

    /// Gets all AXMJPGDec parameters
    STDMETHOD(GetAllParameters)     (THIS_ LPAxMJPGDecParams pAxMJPGDecParams) PURE;

    /// Not implemented for AxMJPGDec
    STDMETHOD(GetDeinterlaceFlags) (THIS_ DWORD  * theDeinterlaceFlags) PURE;

    /// Not implemented for AxMJPGDec
    STDMETHOD(SetDeinterlaceFlags) (THIS_ DWORD  theDeinterlaceFlags) PURE;

    /// Not implemented for AxMJPGDec
    STDMETHOD(SetDeinterlaceFlagsProps) (THIS_ DWORD  theDeinterlaceFlags) PURE; 

    /// Not implemented for AxMJPGDec
    STDMETHOD(GetDecodeFlags) (THIS_ DWORD  * theDecodeFlags) PURE;

    /// Not implemented for AxMJPGDec
    STDMETHOD(SetDecodeFlags) (THIS_ DWORD  theDecodeFlags) PURE;

    /// Not implemented for AxMJPGDec
    STDMETHOD(SetDecodeFlagsProps) (THIS_ DWORD  theDecodeFlags) PURE;

    /// Not implemented for AxMJPGDec
    STDMETHOD(GetDeblock)(THIS_ DWORD  * theDeblockFlag) PURE;    

    /// Not implemented for AxMJPGDec
    STDMETHOD(SetDeblock)(THIS_ DWORD theDeblockFlag) PURE;   

    /// Not implemented for AxMJPGDec
    STDMETHOD(SetDeblockProps)(DWORD theDeblockFlag) PURE;

    /// Not implemented for AxMJPGDec
    STDMETHOD(GetQualitySettings)(DWORD * theQSetting) PURE;    

    /// Not implemented for AxMJPGDec
    STDMETHOD(SetQualitySettings)(DWORD theQSetting) PURE;

    /// Not implemented for AxMJPGDec
    STDMETHOD(SetQualitySettingsProps)(DWORD theQSetting) PURE;

    /// Not implemented for AxMJPGDec
    STDMETHOD(GetCurrentPicture) (THIS_ BYTE * theDstBuffer, DWORD * theSize) PURE; 

    /// Not implemented for AxMJPGDec
    STDMETHOD(GetUserData)(unsigned char * theDstBuffer, DWORD * theSize) PURE;


    /// Register the listener application for callbacks
    STDMETHOD(SetCallback)(IAxMediaCB * theListener, CBMedia theMediaType) PURE;

		/// Call to mirror the frames horizontally when outputting in RGB.
    STDMETHOD(RGBMirror)(bool useMirror) PURE;
  };

  /// GUID Definition
  DEFINE_GUID(CLSID_AXMJPGDEC, 0X29020FE0, 0X3833, 0X4BE2, 0XA7, 0XF0, 0X42, 0X84, 0X1D, 0X4B, 0X45, 0XF0);
  /// GUID Definition
  DEFINE_GUID(CLSID_AXMJPGDECPROP, 0xd5ab8976, 0xa067, 0x4d86, 0xa9, 0x34, 0x5d, 0x18, 0x60, 0xe1, 0xd2, 0x71);
  /// GUID Definition
  DEFINE_GUID(IID_IAxMJPGDec, 0x7404c99f, 0x5b2b, 0x42c2, 0x95, 0x1b, 0x73, 0xd0, 0x9f, 0xb6, 0x6f, 0xba);

#define MJPG_DEC_CLSID "{29020fe0-3833-4be2-a7f0-42841d4b45f0}"
#ifdef __cplusplus
  class DECLSPEC_UUID("29020fe0-3833-4be2-a7f0-42841d4b45f0") CAxMJPGDec;
  class DECLSPEC_UUID("d5ab8976-a067-4d86-a934-5d1860e1d271") CAxMJPGDecProp;
#endif

#ifdef __cplusplus
};	/* extern "C" */
#endif	/* C++ */

#endif // _AXMJPGDEC_INTERFACE_

