/** \AxH264Dec.h
* Custom interface for IAxH264Dec
*
* (C) Copyright 2006, Axis Communications AB, LUND, SWEDEN
****************************************************************************/

#ifndef _AXH264DEC_INTERFACE_
#define _AXH264DEC_INTERFACE_

/****************** INCLUDE FILES SECTION ***********************************/

/****************** DEFINITION SECTION **************************************/

// Decode Mode flags
#define IAXH264DEC_DECODE_MODE_I 0x00
#define IAXH264DEC_DECODE_MODE_IP 0x01
#define IAXH264DEC_DECODE_MODE_ALL 0x02

// Quality Settings flags
#define IAXH264DEC_QUALITY_MODE_FIXED_MASK 0x0F // fixed quality level 0x00 (low) - 0x09 (high)
#define IAXH264DEC_QUALITY_MODE_FIXED_LOW 0x00
#define IAXH264DEC_QUALITY_MODE_FIXED_HIGH 0x09
#define IAXH264DEC_QUALITY_MODE_DYNAMIC 0x10
#define IAXH264DEC_QUALITY_MODE_ALLOW_FRAME_DROPPING 0x100

///////////////////////////////////////////////////////////////////////////////
// Parameter Info
// struct to hold the DMO's Parameters
typedef struct _AxH264DecParams
{
  DWORD DecodeMode;
} AxH264DecParams, *LPAxH264DecParams;
typedef const AxH264DecParams *LPCAxH264DecParams;

#ifndef AX_MEDIA_CB
#define AX_MEDIA_CB
typedef enum {
  CB_NULL                  =  0,
  CB_MEDIA_RGB24           =  1,      
  CB_MEDIA_YV12            =  2,
  CB_MEDIA_YUY2            =  3,
  CB_MEDIA_RGB32           =  4,
  CB_MEDIA_Y               =  5,
} CBMedia;

/// Interface for callbacks
DECLARE_INTERFACE(IAxMediaCB)
{
  STDMETHOD(BufferCB)
    ( 
    LONGLONG  theStartTime,
    BYTE * theDstBuffer, 
    long  theSize
    ) PURE;
};

#endif


#ifdef __cplusplus
extern "C" {
#endif	/* C++ */

/* Forward Declarations */ 
#ifdef __cplusplus
  typedef class CAxH264Dec CAxH264Dec;

#else
  typedef struct CAxH264Dec CAxH264Dec;

#endif /* __cplusplus */

#ifdef __cplusplus
	typedef class CAxH264DecProp CAxH264DecProp;
#else
	typedef struct CAxH264DecProp CAxH264DecProp;
#endif /* __cplusplus */

  interface IAxH264Dec;
#ifndef __cplusplus 
  typedef interface IAxH264Dec IAxH264Dec;
#endif	/* C++ */

/* Interface Definition */
#undef  INTERFACE
#define INTERFACE  IAxH264Dec
  DECLARE_INTERFACE_(IAxH264Dec, IUnknown)
  {
	  // All Parameters (props)
		  STDMETHOD(SetAllParameters)     (THIS_ LPCAxH264DecParams pcAxMP4DecParams) PURE;

		  STDMETHOD(GetAllParameters)     (THIS_ LPAxH264DecParams pAxMP4DecParams) PURE;

      // Decoder skipping mode
      STDMETHOD(GetDecodeFlags) (THIS_ DWORD  * theDecodeFlags) PURE;

      STDMETHOD(SetDecodeFlags) (THIS_ DWORD  theDecodeFlags) PURE;

      STDMETHOD(SetDecodeFlagsProps) (THIS_ DWORD  theDecodeFlags) PURE;
   
      // Extract
      STDMETHOD(GetCurrentPicture) (THIS_ BYTE * theDstBuffer, DWORD * theSize) PURE; 

      STDMETHOD(GetUserData)(unsigned char * theDstBuffer, DWORD * theSize) PURE;

      /// Register the listener application for callbacks
      STDMETHOD(SetCallback)(IAxMediaCB * theListener, CBMedia theMediaType) PURE;

		  /// Call to mirror the frames horizontally when outputting in RGB.
      STDMETHOD(RGBMirror)(bool useMirror) PURE;
  };

  /* Extended interface for H.264 decoder - implemented from version 2.2.0.0 */

  interface IAxH264Dec2;
#ifndef __cplusplus 
  typedef interface IAxH264Dec2 IAxH264Dec2;
#endif	/* C++ */

  /* Interface Definition */
#undef  INTERFACE
#define INTERFACE  IAxH264Dec2
  DECLARE_INTERFACE_(IAxH264Dec2, IUnknown)
  {
    STDMETHOD(GetDeinterlaceFlags) (THIS_ DWORD  *theDeinterlaceFlags); 
    STDMETHOD(SetDeinterlaceFlags) (THIS_ DWORD  theDeinterlaceFlags); 
    STDMETHOD(SetDeinterlaceFlagsProps) (DWORD  theDeinterlaceFlags); 
    STDMETHOD(GetDeblock)(DWORD  * theDeblockFlag);
    STDMETHOD(SetDeblock)(DWORD theDeblockFlag);
    STDMETHOD(SetDeblockProps)(DWORD theDeblockFlag);
    STDMETHOD(GetQualitySettings)(DWORD  * theQSetting);
    STDMETHOD(SetQualitySettings)(DWORD  theQSetting);
    STDMETHOD(SetQualitySettingsProps)(DWORD  theQSetting);
  };

  /* GUID Definition */
  DEFINE_GUID(CLSID_AXH264DEC, 0X7340F0E4, 0XAEDA, 0X47C6, 0X89, 0X71, 0X9D, 0XB3, 0X14, 0X3, 0XB, 0XD7);
  DEFINE_GUID(IID_IAxH264Dec, 0xe8f81ea3, 0x4c67, 0x4f85, 0xba, 0x8, 0x49, 0xe, 0x67, 0x50, 0x9d, 0x10);
  DEFINE_GUID(IID_IAxH264Dec2, 0xad61a4b9, 0xb878, 0x47c8, 0xa2, 0xfa, 0xff, 0x18, 0x78, 0x6d, 0xc5, 0x20);
  DEFINE_GUID(CLSID_AXH264DECPROP,0xc890422f, 0x1be, 0x4642, 0xbf, 0xd5, 0x41, 0x63, 0x99, 0x54, 0x87, 0x29);

  //http://www.fourcc.org
  // H264 is INTEL's FOURCC for h.264
#define FOURCC_H264 mmioFOURCC('H','2','6','4')
  DEFINE_GUID(CLSID_H264, FOURCC_H264, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);
  // We unintentionally used h264 (not registered) in beta versions of our components
#define FOURCC_h264 mmioFOURCC('h','2','6','4')
  DEFINE_GUID(CLSID_h264, FOURCC_h264, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

  // Apple's FOURCC in CAPITALS, not registered but used by the haali splitter.
#define FOURCC_AVC1 mmioFOURCC('A','V','C','1')
  DEFINE_GUID(CLSID_AVC1, FOURCC_AVC1, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);
  // Apple's FOURCC for h.264
#define FOURCC_avc1 mmioFOURCC('a','v','c','1')
  DEFINE_GUID(CLSID_avc1, FOURCC_avc1, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71);



#define H264_DEC_CLSID "{7340f0e4-aeda-47c6-8971-9db314030bd7}"
#ifdef __cplusplus
  class DECLSPEC_UUID("7340f0e4-aeda-47c6-8971-9db314030bd7") CAxH264Dec;
  class DECLSPEC_UUID("C890422F-01BE-4642-BFD5-416399548729") CAxH264DecProp;

#endif

#ifdef __cplusplus
};	/* extern "C" */
#endif	/* C++ */

#endif // _AXH264DEC_INTERFACE_

